<?php
    header("Pragma: no-cache");
    header("Cache: no-cache");
    header("Cache-Control: no-cache, must-revalidate");
    header("Expires: Mon, 26 Jul 1997 05:00:00 GMT");
    require_once('auth.php');
    require('header.php');
    require_once('config.php');
    require_once ("DatabaseConnector.php");
	
	?>
	<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head>
<link rel="stylesheet" href="https://toert.github.io/Isolated-Bootstrap/versions/4.0.0-beta/iso_bootstrap4.0.0min.css">
<meta http-equiv="content-type" content="text/html;charset=utf-8" />
<title><?php echo CUSTOMER_WALLET_APP_DETAILS; ?></title>
<link href="styles.css" rel="stylesheet" type="text/css" />
<link href="calendar.css" type="text/css" rel="stylesheet" />
<script src="calendar.js" type="text/javascript"></script>
<link rel="shortcut icon" href="images/favicon.ico" type="image/x-icon">
<link rel="icon" href="images/favicon.ico" type="image/x-icon" />
<meta http-equiv="Cache-Control" content="no-cache, no-store, must-revalidate">
<meta http-equiv="Pragma" content="no-cache">
<meta http-equiv="Expires" content="0">
</head>

<body>
	
<?php

if(isset($_GET['page']) && is_numeric($_GET['page']) && $_GET['page'] > 0) {
    $page = $_GET['page'];
}
else {
    $page = 1;
}

$page_length = 20;  //Πόσες εγγραφές θα φαίνονται ανά σελίδα
$start = ($page-1) * $page_length;
	

$databaseConnector = new DatabaseConnector(DB_DATABASE, DB_USER, DB_PASSWORD, DB_HOST); 
$pdo = $databaseConnector->getConnection();
$pdo->exec('set names utf8');

$total_customers = $pdo->query('select count(customer_id) from customers where  firebase_web_token != "" AND firebase_web_token is not null')->fetch()[0];
$total_pages =  ceil($total_customers / $page_length);


$sql = 'SELECT customer_id,name,surname,phone,firebase_web_token FROM `customers` where firebase_web_token != "" AND firebase_web_token is not null '
        . 'LIMIT :start, :page_length';

$stmt = $pdo->prepare($sql);
$stmt->bindParam(":start", $start, PDO::PARAM_INT);
$stmt->bindParam(":page_length", $page_length, PDO::PARAM_INT);
$stmt->execute();
$results = $stmt->fetchAll();


?>

	
<?php
   headerDiv();
?>

<div class="bootstrap main" style="max-width: 900px;">
    <h1><?php echo CUSTOMER_WALLET_APP_DETAILS; ?></h1>
    <p>
<div id="table-wrapper">
  <div id="table-scroll" class="table-responsive">
<table class="table" border = "1">
    <thead >
        <tr >
            echo '<th><span class="text">' . IDENTIFIER . '</span></th>';
            echo '<th>' . ONOMA . '</th>';
            echo '<th>' . SURNAME . '</th>';
            echo '<th>' . TELEPHONE . '</th>';
            echo '<th>' . MOBILE_TOKEN . '</th>';
        </tr>
    </thead>
    <tbody>
        <?php
       
        foreach ($results as $result) {
             echo '<tr>';
            echo '<td contenteditable style="max-width:150px;overflow-x:scroll;">'.$result[0] . '</td>'.'<td>'. $result[1] .'</td>'.'<td>'.$result[2].'</td>' .'<td>'.$result[3].'</td>'.'<td>'.$result[4].'</td>';
            echo '</tr>';
        }
        
        ?>
        echo '<tr><td>' . DISPLAYED . ' ' . sizeof($results) . ' ' . FROM_THE_TOTAL . ' ' . $total_customers . ' downloads' . '</td></tr>';
    </tbody>
</table>
  </div>
</div>
&nbsp;</p>

<?php   
if ($page > 1) { ?>
	<a class="btn btn-outline-info mb-4" href="?page=1">First</a>
    <a class="btn btn-outline-info mb-4" href="?page=<?=$page-1?>">Previous</a>  
<?php }
for($i = 1; $i <= $total_pages; $i++) {
    if($i == $page) { ?>
        <a class="btn btn-info mb-4" href="?page=<?=$i?>"><?=$i?></a>
    <?php }
    else if ($i > $page-3 && $i < $page+3) { ?>
    	<a class="btn btn-outline-info mb-4" href="?page=<?=$i?>"><?=$i?></a>
    <?php } 
}

if ($page < $total_pages) { ?>
<a class="btn btn-outline-info mb-4" href="?page=<?=$page+1?>">Next</a>
<a class="btn btn-outline-info mb-4" href="?page=<?=$total_pages?>">Last</a>
<?php } 

?>


</div>
</body>
</html>

