<?php
// Start session and include database connection and other necessary files
session_start();
require_once('config.php');

// Check if the user is logged in
if (!isset($_SESSION['id'])) {
    die('Unauthorized');
}

// Query to fetch transactions with a join on customers and stores tables
$qry = "SELECT transactions.*, stores.store_id, customers.name AS customer_name 
        FROM transactions
        LEFT JOIN stores ON transactions.store_id = stores.id
        LEFT JOIN customers ON transactions.customer_auto_id = customers.id
        WHERE transactions.deleted <> 1 
        AND transactions.customer_auto_id = '" . $_SESSION['id'] . "' 
        ORDER BY transactions.date DESC";

$result = mysqli_query($conn, $qry);

if (!$result) {
    die("Error fetching transactions: " . mysqli_error($conn));
}

// Fetch the results and output them as JSON
$transactions = [];
while ($row = mysqli_fetch_assoc($result)) {
    $transactions[] = $row;
}

// Send the transactions as a JSON response
header('Content-Type: application/json');
echo json_encode($transactions);

mysqli_close($conn);
?>
