<?php
/*******************************
 * Helpers & Polyfills (PHP 5.6)
 *******************************/

// getallheaders() για περιβάλλοντα χωρίς Apache
if (!function_exists('getallheaders')) {
    function getallheaders() {
        $headers = array();
        foreach ($_SERVER as $name => $value) {
            if (substr($name, 0, 5) === 'HTTP_') {
                $key = str_replace(' ', '-', ucwords(strtolower(str_replace('_', ' ', substr($name, 5)))));
                $headers[$key] = $value;
            }
        }
        if (isset($_SERVER['CONTENT_TYPE']))   $headers['Content-Type']   = $_SERVER['CONTENT_TYPE'];
        if (isset($_SERVER['CONTENT_LENGTH'])) $headers['Content-Length'] = $_SERVER['CONTENT_LENGTH'];
        return $headers;
    }
}

// apache_request_headers() polyfill
if (!function_exists('apache_request_headers')) {
    function apache_request_headers() {
        return getallheaders();
    }
}

/**
 * Επιστρέφει το Authorization header με μέγιστη συμβατότητα (Apache/CGI/FPM/Nginx)
 */
function getAuthorizationHeader() {
    // 1) Από headers
    $headers = apache_request_headers();
    foreach ($headers as $k => $v) {
        if (strcasecmp($k, 'Authorization') === 0) {
            return $v;
        }
    }

    // 2) Από server vars (CGI/FastCGI/Nginx)
    if (!empty($_SERVER['HTTP_AUTHORIZATION'])) {
        return $_SERVER['HTTP_AUTHORIZATION'];
    }
    if (!empty($_SERVER['REDIRECT_HTTP_AUTHORIZATION'])) {
        return $_SERVER['REDIRECT_HTTP_AUTHORIZATION'];
    }

    // 3) Από PHP auth μεταβλητές (Basic)
    if (isset($_SERVER['PHP_AUTH_USER'], $_SERVER['PHP_AUTH_PW'])) {
        return 'Basic ' . base64_encode($_SERVER['PHP_AUTH_USER'] . ':' . $_SERVER['PHP_AUTH_PW']);
    }

    return null;
}

/*****************
 * Core Functions
 *****************/

/**
 * Ασφαλής καθαρισμός απλής εισόδου (για output/HTML).
 * Σημ.: Για DB χρησιμοποιούμε escaping στη query.
 */
function secureInput($input) {
    $input = trim($input);
    $input = stripslashes($input);
    return htmlspecialchars($input, ENT_QUOTES, 'UTF-8');
}

/**
 * Προσθέτει πόντους σύστασης.
 * Σημ.: Χρησιμοποιεί mysql_* για συμβατότητα PHP 5.6.
 */
function addReferralPoints($fromCustomerId, $toCustomerId, $points, $userId, $storeId, $dateNow = null)
{
    // Αν δεν έχει οριστεί, μην πετάει notice
    if (defined('REFERRAL_BONUS') && REFERRAL_BONUS === false) return;
    if (empty($toCustomerId)) return;

    // Σύνδεση DB
    $link = mysql_connect(DB_HOST, DB_USER, DB_PASSWORD);
    if (!$link) {
        die('DB server error: ' . mysql_error());
    }
    if (!mysql_select_db(DB_DATABASE, $link)) {
        die('DB select error');
    }

    // UTF-8 παντού
    mysql_query("SET NAMES 'utf8'", $link);
    mysql_query("SET CHARACTER SET 'utf8'", $link);

    // Ημερομηνία
    if (empty($dateNow)) {
        $dateNow = date('Y-m-d H:i:s');
    }

    // Ασφάλεια τιμών
    $toCustomerIdEsc = mysql_real_escape_string($toCustomerId, $link);
    $fromCustomerIdEsc = mysql_real_escape_string($fromCustomerId, $link);
    $pointsInt  = (int)$points;
    $userIdInt  = (int)$userId;
    $storeIdInt = (int)$storeId;

    // Βρες τον πελάτη
    $qry = "SELECT id, name, surname, customer_id 
            FROM customers 
            WHERE customer_id = '".$toCustomerIdEsc."' 
            LIMIT 1";

    $result = mysql_query($qry, $link) or die(mysql_error($link));

    if (mysql_num_rows($result) > 0) {
        $user = mysql_fetch_array($result);

        $notes = 'Πόντοι σύστασης από ' . $fromCustomerIdEsc;

        $insertQuery = "INSERT INTO transactions 
            (`customer_auto_id`,`money`,`points`,`date`,`by`,`store_id`,`notes`,`services`,`giftcard_id`,`giftcard_money`)
            VALUES
            ('".$user['id']."','0','".$pointsInt."','".mysql_real_escape_string($dateNow, $link)."',
             '".$userIdInt."','".$storeIdInt."','".mysql_real_escape_string($notes, $link)."','',NULL,0)";

        mysql_query($insertQuery, $link) or die(mysql_error($link));
    }

    // προαιρετικά: mysql_close($link);
}

/**
 * Basic/Bearer auth validator με πλήρη συμβατότητα headers.
 */
function authenticateApiUser($apiUserService) {
    $header = getAuthorizationHeader();
    $token  = null;

    if ($header) {
        $header = trim($header);
        if (stripos($header, 'Basic ') === 0) {
            $token = trim(substr($header, 6));   // μετά το "Basic "
        } elseif (stripos($header, 'Bearer ') === 0) {
            $token = trim(substr($header, 7));   // μετά το "Bearer "
        }
    }

    if (!$apiUserService->isBasicAuthenticationTokenValid($token)) {
        header('WWW-Authenticate: Basic realm="Restricted access"');
        header('HTTP/1.0 401 Unauthorized');
        exit('Not authorized');
    }
}

/**
 * Έλεγχος login μέσω session.
 */
function isLoggedIn() {
    // Ξεκίνα session αν δεν έχει ξεκινήσει
    if (session_id() === '') {
        @session_start();
    }

    // Έλεγχος μεταβλητής session
    if (!isset($_SESSION['SESS_USER_ID']) || trim($_SESSION['SESS_USER_ID']) === '') {
        return false;
    }
    return true;
}
