<?php

require_once 'CrudDao.php';
require_once 'models/Transaction.php';
require_once 'utils/SQLFilter.php';

class TransactionDao extends CrudDao {

    /**
     * 
     * @param PDO $connection
     */
    public function __construct($connection) {
        parent::__construct($connection);
        $this->connection = $connection;
    }

    protected function getTableName() {
        return "transactions";
    }

    protected function getClassName() {
        return Transaction::class;
    }
    
    public function getTransactionsJoinedCustomer($customerId) {
        $sql = "SELECT * FROM `customers` JOIN `transactions` ON customers.id = transactions.customer_id WHERE customer_id = :customer_id \n";
        $this->connection->exec('set names utf8');
        $stmt = $this->connection->prepare($sql);
        $stmt->bindParam(":customer_id", $customer_id);

        $stmt->execute();

         // $result['customer_id'], $result['name'], $result['surname'], $result['street'], $result['phone'],$result['email']
        return $stmt->fetchAll();
    }
}


