<?php


/**
 * Από default κατάσταση είναι για να συνδέεται σε mysql db
 *  Για να συνδεθούμε σε διαφορετική db απλά αλλάζουμε το $dsn
 */
class DatabaseConnector {
    
  
    private $dbname; //Όνομα databse
    private $user;   //Όνομα user
    private $password;  //Κωδικός
    private $host;   //ip address
    private $dsn;    //URL
    
    /**
     * 
     * @param string $dbname
     * @param string $user
     * @param string $password
     * @param string $host
     */
    public function __construct($dbname, $user, $password, $host) {
        $this->dbname = $dbname;
        $this->user = $user;
        $this->password = $password;
        $this->host = $host;
        $this->dsn = "mysql:host=$this->host;dbname=$this->dbname";
    }
    
    public function __set($name, $value) {
        $this->$name = $value;
    }
    
    public function __get($user) {
        return $this->$user;
    }
    
    /**
     * 
     * @return PDO
     */
    public function getConnection() {
        //αν παεί κάτι στραβά πετάει exception
        return new PDO($this->dsn, $this->user, $this->password,array(PDO::ATTR_ERRMODE => PDO::ERRMODE_EXCEPTION));
    }
    
    public function __toString() {
        $objectInfo = "";
        return "Database name: $this->dbname \n"
        . "User: $this->user \n"
        . "Password: $this->password \n"
        . "Host: $this->host  \n"
        . "DSN : $this->dsn";
    }
    
}

?>