<?php
header("Pragma: no-cache");
header("Cache: no-cache");
header("Cache-Control: no-cache, must-revalidate");
header("Expires: Mon, 26 Jul 1997 05:00:00 GMT");

require_once('config.php');
require_once('auth.php');
require_once('admin.php');
require('header.php');

?>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN""http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head>
    <meta http-equiv="content-type" content="text/html;charset=utf-8"/>
    <title><?php echo TITLE_VIEW_QUESTIONNAIRE_STATS; ?></title>
    <link href="styles.css" rel="stylesheet" type="text/css"/>
    <link href="calendar.css" type="text/css" rel="stylesheet"/>
    <script type="text/javascript" src="Chart.min.js"></script>
    <script type="text/javascript">
        function printDiv() {
            var content = document.getElementById("printable");
            if (typeof(content) == 'undefined' || content == null) return;
            var pri = document.getElementById("printwindow").contentWindow;
            pri.document.open();
            pri.document.write('<div><img src="images/logo.png" /><br /><br />');
            pri.document.write(content.innerHTML);
            pri.document.write('<br /></div>');
            pri.document.close();
            pri.focus();
            pri.print();
        }
    </script>
    <script src="calendar.js" type="text/javascript"></script>
    <link rel="shortcut icon" href="images/favicon.ico" type="image/x-icon">
    <link rel="icon" href="images/favicon.ico" type="image/x-icon"/>
    <meta http-equiv="Cache-Control" content="no-cache, no-store, must-revalidate">
    <meta http-equiv="Pragma" content="no-cache">
    <meta http-equiv="Expires" content="0">
</head>

<body>
<?php headerDiv(); ?>


<div class="main">
    <h1><?php echo HEADER_VIEW_QUESTIONNAIRE_STATS_PER_SESSION; ?></h1>

    <?php
    $link = mysql_connect(DB_HOST, DB_USER, DB_PASSWORD);
    if (!$link) {
        die(ERROR_DATABASE_CONNECTION_FAILURE);
    }
    $db = mysql_select_db(DB_DATABASE);
    if (!$db) {
        die("Unable to select database");
    }
    mysql_query("SET character_set_results = 'utf8', character_set_client = 'utf8', character_set_connection = 'utf8', character_set_database = 'latin1', character_set_server = 'latin1'",
        $link)
    or die(mysql_error());

    foreach (json_decode(file_get_contents("questionnaire/questions.js"), true) as $question) {
        $questions[$question['id']] = array(
            "title" => $question['title'],
            "total" => 0,
            "answers" => array("1" => 0, "2" => 0, "3" => 0, "4" => 0, "5" => 0)
        );
    }
    ?>

    <form method="post" action="" style="margin:20px;">
        <table cellspacing="0">
            <tr>
                <td><label for="from_date"><?php echo LABEL_FROM; ?></label></td>
                <td>
                    <input type="text" size="8" name="from_date" id="from_date"
                           value="<?php if (!isset($_POST['from_date'])) {
                               echo date("Y-m-d");
                           } else echo $_POST['from_date'] ?>"/>
                    <script type="text/javascript"> calendar.set("from_date");</script>
                </td>
                <td rowspan="3" style="padding-left:20px;">
                    <button type="submit" class="styled">
                        <img alt="" src="images/refresh.png" class="icon"/> <?php echo TEXT_REFRESH; ?>
                    </button>
                </td>
            </tr>
            <tr>
                <td><label for="till_date"><?php echo LABEL_TILL; ?></label></td>
                <td>
                    <input type="text" size="8" name="till_date" id="till_date"
                           value="<?php if (!isset($_POST['till_date'])) {
                               echo date("Y-m-d");
                           } else echo $_POST['till_date'] ?>"/>
                    <script type="text/javascript"> calendar.set("till_date");</script>
                </td>
            </tr>
            <tr>
                <td><label for="user_id"><?php echo LABEL_SESSION; ?></label></td>
                <td>
                    <select name="user_id" id="user_id" style="width:150px;">
                        <option value=""><?php echo OPTION_SELECT_SESSION; ?></option>
                        <?php
                        $result = mysql_query("SELECT id, CONCAT(real_name, ' ', real_surname) AS name FROM users ORDER BY name")
                        or die(mysql_error());
                        while ($row = mysql_fetch_array($result)) {
                            echo '<option ';
                            if (isset($_POST['user_id']) && $_POST['user_id'] == $row['id']) {
                                echo ' selected ';
                            }
                            echo ' value="' . $row['id'] . '">' . $row['name'] . '</option>
						';
                        }
                        ?>
                    </select>
                </td>
            </tr>
        </table>
    </form>
    <?php
    $where = array();

    /* set the date filter */
    $from_date = date("Y-m-d") . " 00:00:01";
    $till_date = date("Y-m-d") . " 23:59:59";
    if (!empty($_POST['from_date'])) {
        $from_date = $_POST['from_date'] . " 00:00:01";
    }
    if (!empty($_POST['till_date'])) {
        $till_date = $_POST['till_date'] . " 23:59:59";
    }
    $where[] = "`s`.`date` >= '" . $from_date . "' AND `s`.`date` <= '" . $till_date . "'";

    /* set the user filter */
    if (!empty($_POST['user_id'])) {
        $where[] = "`s`.`user_id` = " . $_POST['user_id'];
    }

    if (count($where) != 2) {
        <p class="main"><?php echo TEXT_PLEASE_SELECT_DATE_AND_SESSION; ?></p>
    } else {
        $query = "SELECT `c`.`surname`, `c`.`name`, `s`.`question`, `s`.`answer`, `s`.`comments` AS `destination`
                  FROM `survey` AS `s`
                  JOIN `customers` AS `c` ON `s`.`customer_auto_id` = `c`.`id`
                  WHERE " . implode(" AND ", $where) . "
                  ORDER BY `s`.`date` DESC, `c`.`name` ASC, `c`.`surname` ASC, `s`.`question` ASC, `s`.`answer` ASC";
        $result = mysql_query($query) or die(mysql_error());

        if (!mysql_num_rows($result)) {
            die(ERROR_DATABASE_CONNECTION_FAILURE);
        } else {
            echo '<div id="printable" >';
            echo '<table class="main" style="float: left; width: 400px" cellspacing="0">';
            echo '<tr style="font-weight:bold;text-align:center;">';
            echo '<td>Όνομα</td><td class="leftborder">Επώνυμο</td><td class="leftborder">Ερώτηση</td><td class="leftborder">Απάντηση</td><td class="leftborder">Προορισμός</td>';
            echo '</tr>';

            $counter = 0;
            while ($row = mysql_fetch_array($result)) {
                echo '<tr class=' . ($counter++ % 2 ? "even" : "odd") . '>';
                echo '<td>' . $row['name'] . '</td>';
                echo '<td class="leftborder">' . $row['surname'] . '</td>';
                echo '<td class="leftborder">' . $questions[$row['question']]['title'] . '</td>';
                echo '<td class="leftborder">' . $row['answer'] . '</td>';
                echo '<td class="leftborder">' . $row['destination'] . '</td>';
                echo '</tr>';
                $questions[$row['question']]['answers'][$row['answer']]++;
                $questions[$row['question']]['total']++;
            }
            echo '</table>';

            foreach($questions as $id => $question) {
                echo '<div style="display: block;width: 300px; float: left;"><p style="color: #555; font-weight: bold; width: 95%; margin: 10px 0">' . $question['title'] . '</p>';
                echo '<canvas style="float:left" id="chart_question_' . $id . '" width="250" height="250"></canvas>';
                echo '</div>';
            }
            echo '<div style="clear:both"></div>';
            echo '</div>'; //printable

            echo '<script type="text/javascript" language="javascript">';
            echo 'window.onload = function() {';

            foreach($questions as $id => $question) {
                $pieData = array(
                    "datasets" => array(
                        array(
                            "labels" => array(),
                            "data" => array(),
                            "backgroundColor" => array()
                        )
                    )
                );
                $pieData['labels'][0] = "Απάντηση 1 (" . round($question['answers'][1] * 100 / $question['total'], 1) . "%)";
                $pieData['labels'][1] = "Απάντηση 2 (" . round($question['answers'][2] * 100 / $question['total'], 1) . "%)";
                $pieData['labels'][2] = "Απάντηση 3 (" . round($question['answers'][3] * 100 / $question['total'], 1) . "%)";
                $pieData['labels'][3] = "Απάντηση 4 (" . round($question['answers'][4] * 100 / $question['total'], 1) . "%)";
                $pieData['labels'][4] = "Απάντηση 5 (" . round($question['answers'][5] * 100 / $question['total'], 1) . "%)";
                $pieData['datasets'][0]['data'][0] = (int)$question['answers'][1];
                $pieData['datasets'][0]['data'][1] = (int)$question['answers'][2];
                $pieData['datasets'][0]['data'][2] = (int)$question['answers'][3];
                $pieData['datasets'][0]['data'][3] = (int)$question['answers'][4];
                $pieData['datasets'][0]['data'][4] = (int)$question['answers'][5];
                $pieData['datasets'][0]['backgroundColor'] = array("#BEABCB", "#BFECCA", "#ECCEBF", "#C2BFEC", "#ECBFE3");

                echo 'window.myBar = new Chart(document.getElementById("chart_question_' . $id . '").getContext("2d"), {
                        type: "pie",
                        data: ' . json_encode($pieData) . ',
                        options: {
                            legend: {
                                position: "bottom"
                            },
                            responsive: false
                        }
                    });';
            }

            echo '};</script>';
        }
    }

    ?>
    <div class="printButton">
        <button type="button" class="styled" onclick="printDiv();"><img alt="" src="images/print.png" class="icon"/>
            <button><?php echo BUTTON_PRINT; ?></button>
        </button>
    </div>
</div>

<iframe id="printwindow" frameborder="0"></iframe>

</body>
</html>
