<?php
	header("Pragma: no-cache");
    header("Cache: no-cache");
    header("Cache-Control: no-cache, must-revalidate");
    header("Expires: Mon, 26 Jul 1997 05:00:00 GMT");
    
	require_once('config.php');
	require_once('auth.php');
	require_once('nowsms.php');
	require_once('admin.php');
	require('header.php');

?>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head>
	<meta http-equiv="content-type" content="text/html;charset=utf-8" />
	<title>Λίστες SMS</title>
	<link href="styles.css" rel="stylesheet" type="text/css" />
	<link rel="shortcut icon" href="images/favicon.ico" type="image/x-icon">
	<link rel="icon" href="images/favicon.ico" type="image/x-icon" />
	<meta http-equiv="Cache-Control" content="no-cache, no-store, must-revalidate">
	<meta http-equiv="Pragma" content="no-cache">
	<meta http-equiv="Expires" content="0">
	<script type="text/javascript" language="javascript">
		function redirectAfterConfirm(url){
			if(confirm("Είστε σίγουρος για την ενέργεια αυτή;")) {
				window.location = url;
			}
		}
	</script>
</head>

<body>
	
<?php headerDiv();?>


<div class="main">
<h1>Λίστες SMS</h1>
	<p class="main">Λίστες που υπάρχουν αυτή τη στιγμή: </p>
	
	<?php
		$allLists = NowSMSDListAllLists();
		if(empty($allLists)) 
			echo "<Δε βρέθηκε κάποια λίστα>";
		else {
			echo "<table border='1' style='border-spacing:0px; text-align:center;' >";
			echo "<tr><th style='padding:5px 10px'>Όνομα λίστας</th><th style='padding:5px 5px'>Αριθμοί</th><th colspan='2' style='padding:5px 10px'>Ενέργειες</th></tr>";
			foreach ($allLists as $dlist) {
				$contains = count(NowSMSDListMembers($dlist));
				echo "<tr>";
				echo "<td>".$dlist."</td>";
				echo "<td>".$contains."</td>";
				echo '<td><a href="#" onclick="redirectAfterConfirm(\'admin-sms-clear-dlist-exec.php?dlist='.$dlist.'\')">Καθαρισμός</a></td>';
				echo '<td><a href="#" onclick="redirectAfterConfirm(\'admin-sms-delete-dlist-exec.php?dlist='.$dlist.'\')">Διαγραφή</a></td></tr>';
			}
			echo "</table>";
		}
	
		$listsToHave = array(toDlistName("all"));
		for ($i = 1; $i <= CUSTOM_FIELDS_NUM; $i++) {
			if(isset($_SESSION['SESS_CUSTOM_FIELD'.$i]) && $_SESSION['SESS_CUSTOM_FIELD'.$i] != "" && isset($_SESSION['SESS_CUSTOM_FIELD_TYPE' . $i]) && $_SESSION['SESS_CUSTOM_FIELD_TYPE' . $i] == "1"){
				$listsToHave[] = toDlistName($_SESSION['SESS_CUSTOM_FIELD'.$i]);
			}
		}

		$listsToCreate = array();
		foreach ($listsToHave as $dlist) {
			if(!in_array($dlist, $allLists))
				$listsToCreate[] = $dlist;
		}

		if(empty($listsToCreate)) 
			echo '<p class="main">Δε χρειάζεται να δημιουργηθεί κάποια λίστα.</p>';
		else {
			echo '<p class="main">Πρέπει να δημιουργηθούν οι παρακάτω λίστες SMS:</p>';
			echo "<ul>";
			foreach ($listsToCreate as $dlist) {
				echo "<li>".$dlist."</li>";
			}
			echo "</ul>";
			?>
			<button type="button" class="styled" onClick="window.location.href='admin-sms-create-dlist-exec.php'">
				<img src="images/apply.png" class="icon" /> Δημιουργία
			</button>
			<?php
		}
	?>

	<button type="button" class="styled" onClick="window.location.href='user-index.php'">
		<img src="images/home.png" class="icon" /> Επιστροφή
	</button>

</div>

</body>
</html>
