<?php
	header("Pragma: no-cache");
    header("Cache: no-cache");
    header("Cache-Control: no-cache, must-revalidate");
    header("Expires: Mon, 26 Jul 1997 05:00:00 GMT");
    
	require_once('auth.php');
	require_once('admin.php');
	require('config.php');
	require('header.php');

?>
<!DOCTYPE html PUBLIC "-//W3C//Dtd XHTML 1.0 Transitional//EN" "http://www.w3.org/tr/xhtml1/Dtd/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head>
<meta http-equiv="content-type" content="text/html;charset=utf-8" />
<title><?php echo SYSTEM_SETTINGS_TITLE; ?></title>
<link href="styles.css" rel="stylesheet" type="text/css" />
<script language="JavaScript" src="form_validator.js"
    type="text/javascript" xml:space="preserve"></script>
<link rel="shortcut icon" href="images/favicon.ico" type="image/x-icon">
<link rel="icon" href="images/favicon.ico" type="image/x-icon" />
<meta http-equiv="Cache-Control" content="no-cache, no-store, must-revalidate">
<meta http-equiv="Pragma" content="no-cache">
<meta http-equiv="Expires" content="0">
    <script type="text/javascript">
        function handleCustomField(select, num) {
            var list = document.getElementById('customfieldlist' + num);
            if(select.value == "3") {
                list.style.display = 'block';
            }
            else {
                list.style.display = 'none';
            }
        }
        function servicesValidation(textarea) {
            var servicesArray = textarea.value.split(",");

            for (index = 0; index < servicesArray.length; ++index) {
                var res = /.*\(x[0-9\.]+\)$/.test(servicesArray[index]);
                if(!res) {
                    alert("Please check the services/products content: " + servicesArray[index]);
                }
            }
        }
    </script>
</head>

<body>
	
<?php headerDiv();?>



<div class="main">
	<h1><?php echo SYSTEM_SETTINGS_TITLE; ?><span style="float: right;color: black;text-shadow: none;font-size: 10px;margin: 5px 0;"><?=file_get_contents("version.php")?></span></h1>
	<form action="admin-settings-exec.php" method="post" name="settings" id="settings">
    <div class="container-fluid">
        
        <!-- Points Settings -->
        <div class="row">
            <div class="col-md-12">
                <h5 class="fw-bold text-decoration-underline">
                    <?php echo POINTS_SETTINGS_LABEL; ?>
                    <br><?php echo EXAMPLE_REWARDS; ?>
                </h5>
                <strong><?php echo LOYALTY_SYSTEM_OPERATES_3_WAYS; ?></strong>
            </div>
        </div>
        <div class="row mb-3">
            <div class="col-md-12">
                <label for="visitpoints"><?php echo POINTS_PER_VISIT_LABEL; ?>:</label>
                <input type="text" id="visitpoints" name="visitpoints" class="form-control d-inline-block" style="width: 100px;" value="<?php echo $_SESSION['SESS_VISIT_POINTS']; ?>" />
            </div>
        </div>
        <hr>

        <div class="row mb-3">
            <div class="col-md-12">
                <label for="moneypoints"><?php echo POINTS_PER_EURO_LABEL; ?>:</label>
                <input type="text" id="moneypoints" name="moneypoints" class="form-control d-inline-block" style="width: 100px;" value="<?php echo $_SESSION['SESS_MONEY_POINTS']; ?>" />
            </div>
        </div>
        <hr>

        <div class="row mb-3">
            <div class="col-md-12">
                <label for="money_back_per_point"><?php echo POSOSTO_EPIS; ?> (<?php echo STIN_ELEYTHERI_EXAR; ?>):</label>
                <input type="text" id="money_back_per_point" name="money_back_per_point" class="form-control d-inline-block" style="width: 100px;" value="<?= isset($_SESSION['SESS_MONEY_BACK_PER_POINT']) ? $_SESSION['SESS_MONEY_BACK_PER_POINT'] : '0'; ?>" />
                <small class="form-text text-muted">The cashback functionality operates as follows: Members earn 1 point for every euro spent. These points can then be converted into a percentage cashback in euros.</small>
            </div>
        </div>
        <hr>

        <div class="row mb-3">
            <div class="col-md-12">
                <label for="referralmoneypoints"><?php echo RECOMMENDATION_POINTS_PERCENTAGE; ?>:</label>
                <input type="text" id="referralmoneypoints" name="referralmoneypoints" class="form-control d-inline-block" style="width: 100px;" value="<?= isset($_SESSION['SESS_REFERRALMONEYPOINTS']) ? $_SESSION['SESS_REFERRALMONEYPOINTS'] : '0'; ?>" />
             <br>Deduct the reward points when redeem ? <input type="hidden" name="removecheckoutpoints" value="<?= isset($_SESSION['SESS_REMOVE_CHECKOUT_POINTS']) && $_SESSION['SESS_REMOVE_CHECKOUT_POINTS'] == "1"? '1':'0'; ?>" />
                <input type="checkbox" value="1" checked="checked" enabled />  Yes
                </div>
        </div>
        <hr>
  
        <!-- Loyalty Time Settings -->
        <div class="row mb-3">
            <div class="col-md-12">
                <h5 class="fw-bold text-decoration-underline"><?php echo PISTOTITA_PELATON; ?></h5>
            </div>
            <div class="col-md-6">
                <label for="loyalty_time_a"><?php echo CHRONOS_A_DIISTIMA_SE_HMERES_POU; ?>:</label>
                <input type="text" id="loyalty_time_a" name="loyalty_time_a" class="form-control" value="<?= isset($_SESSION['SESS_LOYALTY_TIME_A']) ? $_SESSION['SESS_LOYALTY_TIME_A'] : ""; ?>" />
            </div>
            <div class="col-md-6">
                <label for="loyalty_time_b"><?php echo CHRONOS_B_DIISTIMA_SE_HMERES_APO_S; ?>:</label>
                <input type="text" id="loyalty_time_b" name="loyalty_time_b" class="form-control" value="<?= isset($_SESSION['SESS_LOYALTY_TIME_B']) ? $_SESSION['SESS_LOYALTY_TIME_B'] : ""; ?>" />
            </div>
        </div>
        <hr>

        <!-- Penalty Settings -->
        <div class="row mb-3">
            <div class="col-md-12">
                <h5 class="fw-bold text-decoration-underline">Point deduction penalty</h5>
                <label>If a member's last transaction is older than [number] days, [number] points will be deducted:</label>
                <div class="input-group">
                    <input type="text" name="penalty_days" class="form-control" style="width: 100px;" value="<?= isset($_SESSION['SESS_PENALTY_DAYS']) ? $_SESSION['SESS_PENALTY_DAYS'] : ""; ?>" />
                    <input type="text" name="penalty_points" class="form-control" style="width: 100px;" value="<?= isset($_SESSION['SESS_PENALTY_POINTS']) ? $_SESSION['SESS_PENALTY_POINTS'] : ""; ?>" />
                </div>
                <small class="form-text text-muted">If the member's point balance is less than the deduction amount, their points will be set to zero. Set deduction to 0 to disable this penalty.</small>
            </div>
        </div>
        <hr>

        <!-- Services Settings -->
        <div class="row mb-3">
            <div class="col-md-12">
                <h5 class="fw-bold text-decoration-underline">Service settings</h5>
                <button type="button" class="btn btn-primary" onClick="window.location.href='services-settings.php'">
                    <i class="fas fa-cogs"></i> Manage Products/Services by category/subcategory
                </button>
            </div>
        </div>
       <hr>
<!-- Services -->
<tr <?= !DISPLAY_SERVICES ? 'style="display:none;"' : ''; ?>>
    <td colspan="2" style="font-weight:bold;text-decoration:underline;">
Products/services settings    </td>
</tr>
<tr <?= !DISPLAY_SERVICES ? 'style="display:none;"' : ''; ?>>
    <td>Products/services :<br />(separate with comma, e.g. product_category1(x1),product_category2(x2))
        <?php
            if (ALLOW_SERVICES_MULTIPLY) {
               // echo "<br>Προσθέστε (xΠόντοι) για να καθορίσετε τους<br> πόντους ανά υπηρεσία X την τιμή ανά ευρώ";
            }
        ?><br>
    </td>
    <td>
        <textarea name="services" style="height: 50px; width: 350px;" <?= ALLOW_SERVICES_MULTIPLY ? 'onblur="servicesValidation(this)"' : ''; ?>><?php echo $_SESSION['SESS_SERVICES']; ?></textarea><br>
    </td>
</tr>

<!-- <tr>
    <td colspan="2" style="font-weight:bold;text-decoration:underline;">
        <button type="button" class="styled" onClick="window.location.href='services-settings.php'">
            <img src="images/users.png" class="icon" /> Products/services settings
        </button>
    </td>
</tr> -->

        <!-- Custom Fields Settings -->
        <div class="row mb-3">
            <div class="col-md-12">
                <h5 class="fw-bold text-decoration-underline"><?php echo CUSTOM_FIELDS; ?></h5>
                <table class="table table-bordered">
                    <thead>
                        <tr>
                            <th>#</th>
                            <th>Title</th>
                            <th>Type</th>
                            <th>Options</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php for ($i = 1; $i <= CUSTOM_FIELDS_NUM; $i++) { ?>
                        <tr>
                            <td>CustomField <?php echo $i; ?>:</td>
                            <td><input type="text" name="customfield<?php echo $i; ?>" class="form-control" value="<?= isset($_SESSION['SESS_CUSTOM_FIELD' . $i]) ? $_SESSION['SESS_CUSTOM_FIELD' . $i] : ""; ?>" /></td>
                            <td>
                                <select name="customfieldtype<?php echo $i; ?>" class="form-select" onchange="handleCustomField(this, <?php echo $i; ?>);">
                                    <option value="1" <?= isset($_SESSION['SESS_CUSTOM_FIELD_TYPE' . $i]) && $_SESSION['SESS_CUSTOM_FIELD_TYPE' . $i] == "1" ? 'selected' : ""; ?>>Yes/No</option>
                                    <option value="2" <?= isset($_SESSION['SESS_CUSTOM_FIELD_TYPE' . $i]) && $_SESSION['SESS_CUSTOM_FIELD_TYPE' . $i] == "2" ? 'selected' : ""; ?>>Text</option>
                                    <option value="3" <?= isset($_SESSION['SESS_CUSTOM_FIELD_TYPE' . $i]) && $_SESSION['SESS_CUSTOM_FIELD_TYPE' . $i] == "3" ? 'selected' : ""; ?>>List</option>
                                </select>
                            </td>
                            <td>
                                <textarea id="customfieldlist<?php echo $i; ?>" name="customfieldlist<?php echo $i; ?>" class="form-control" style="display: <?= isset($_SESSION['SESS_CUSTOM_FIELD_TYPE' . $i]) && $_SESSION['SESS_CUSTOM_FIELD_TYPE' . $i] == "3" ? 'block' : 'none'; ?>"><?= $_SESSION['SESS_CUSTOM_FIELD_LIST' . $i]; ?></textarea>
                            </td>
                        </tr>
                        <?php } ?>
                    </tbody>
                </table>
            </div>
        </div>
        <hr>

        <!-- User Settings -->
        <div class="row mb-3">
            <div class="col-md-12">
                <h5 class="fw-bold text-decoration-underline">System user settings</h5>
                <button type="button" class="btn btn-primary" onClick="window.location.href='admin-view-users.php'">
                    <i class="fas fa-users"></i> View Users
                </button>
                <button type="button" class="btn btn-primary" onClick="window.location.href='admin-new-user-form.php'">
                    <i class="fas fa-user-plus"></i> New User Registration
                </button>
            </div>
        </div>
        <hr>

        <!-- Store Settings -->
        <div class="row mb-3">
            <div class="col-md-12">
                <h5 class="fw-bold text-decoration-underline">Store settings</h5>
                <button type="button" class="btn btn-primary" onClick="window.location.href='admin-view-stores.php'">
                    <i class="fas fa-store"></i> View Stores
                </button>
            </div>
        </div>
        <hr>

        <!-- Export Data Section -->
        <div class="row mb-3">
            <div class="col-md-12">
                <h5 class="fw-bold text-decoration-underline">Backups</h5>
                <label><?php echo SELECT_TABLE_FOR_EXPORT; ?>:</label>
                <button type="button" class="btn btn-secondary" onClick="window.location.href='admin-export-database-customers.php'">
                    <i class="fas fa-save"></i> <?php echo CUSTOMERS; ?>
                </button>
                <button type="button" class="btn btn-secondary" onClick="window.location.href='admin-export-database-transactions.php'">
                    <i class="fas fa-save"></i> <?php echo TRANSACTIONS; ?>
                </button>
            </div>
        </div>
        <hr>
<!-- Import transactions -->
        <div class="row mb-3">
            <div class="col-md-12">
                <h5 class="fw-bold text-decoration-underline">Import Transactions</h5>
                <button type="button" class="btn btn-primary" onClick="window.location.href='admin-upload-transactions-form.php'">
                    <i class="fas fa-sms"></i> Import transactions from csv file
                </button>
               
            </div>
        </div>
        <hr>
        <!-- SMS & Email Settings -->
        <div class="row mb-3">
            <div class="col-md-12">
                <h5 class="fw-bold text-decoration-underline">SMS & Email Settings</h5>
                <button type="button" class="btn btn-primary" onClick="window.location.href='admin-sms-settings-form.php'">
                    <i class="fas fa-sms"></i> SMS Settings
                </button>
                <button type="button" class="btn btn-primary" onClick="window.location.href='admin-email-settings-form.php'">
                    <i class="fas fa-envelope"></i> Email Settings
                </button>
            </div>
        </div>
        <hr>

        <!-- Save Button -->
        <div class="row mb-3">
            <div class="col-md-12 text-center">
                <button type="submit" class="btn btn-success">
                    <i class="fas fa-save"></i> Save Settings
                </button>
            </div>
        </div>
    </div>
</form>
<pre>
    
    
    
</pre>
<script type="text/javascript">
//<![CDATA[
  var frmvalidator  = new Validator("settings");
  frmvalidator.EnableOnPageErrorDisplaySingleBox();
  frmvalidator.EnableMsgsTogether();

  // Assuming these constants are defined in PHP, use PHP echo to insert them into JavaScript
  frmvalidator.addValidation("visitpoints", "req", "<?php echo NO_VISITPOINTS_ENTERED; ?>");
  frmvalidator.addValidation("visitpoints", "decimal", "<?php echo POINTS_MUST_BE_NUMBER; ?>");

  frmvalidator.addValidation("moneypoints", "req", "<?php echo NO_MONEYPOINTS_ENTERED; ?>");
  frmvalidator.addValidation("moneypoints", "decimal", "<?php echo POINTS_MUST_BE_NUMBER; ?>");
//]]>
</script>

</div>

</body>
</html>
