<?php
	header("Pragma: no-cache");
    header("Cache: no-cache");
    header("Cache-Control: no-cache, must-revalidate");
    header("Expires: Mon, 26 Jul 1997 05:00:00 GMT");

    die("<a href='user-index.php'>Access denied...</a>");

	require_once('auth.php');
	require_once('config.php');
	require('admin.php');
	require('header.php');


?>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head>
<meta http-equiv="content-type" content="text/html;charset=utf-8" />
<title><?php echo CREATION_OF_STORE; ?></title>
<link href="styles.css" rel="stylesheet" type="text/css" />
<script language="JavaScript" src="form_validator.js"
    type="text/javascript" xml:space="preserve"></script>
<link rel="shortcut icon" href="images/favicon.ico" type="image/x-icon">
<link rel="icon" href="images/favicon.ico" type="image/x-icon" />
<meta http-equiv="Cache-Control" content="no-cache, no-store, must-revalidate">
<meta http-equiv="Pragma" content="no-cache">
<meta http-equiv="Expires" content="0">
</head>

<body>

<?php headerDiv();?>


<div class="main">
<h1><?php echo CREATION_OF_STORE; ?></h1>
	<div id="new-store_errorloc"></div>

	<form action="admin-new-store-exec.php" method="post" name="new-store" id="new-store" >
	<table class="main">
		<tr>
			<td><?php echo STORE_IDENTIFIER; ?></td>
			<td><input type="text" name="store_id" size="20"/> *</td>
		</tr>
		<tr>
			<td><?php echo TAX_ID; ?></td>
			<td><input type="text" name="afm" size="20"/> *</td>
		</tr>
		<tr>
			<td><?php echo RESPONSIBLE_PERSON_NAME; ?></td>
			<td><input type="text" name="name" size="20"/> *</td>
		</tr>
		<tr>
			<td><?php echo RESPONSIBLE_PERSON_SURNAME; ?></td>
			<td><input type="text" name="surname" size="20"/> *</td>
		</tr>

		<tr>
			<td><?php echo ADDRESS; ?></td>
			<td><input type="text" name="street" size="20"/> *</td>
		</tr>
		<tr>
			<td><?php echo CITY; ?></td>
			<td><input type="text" name="city" size="20" value="Λάρισα"/> *</td>
		</tr>
		<tr>
			<td><?php echo COUNTRY; ?></td>
			<td><input type="text" name="country" size="20" value="Ελλάδα"/> *</td>
		</tr>
		<tr>
			<td><?php echo POSTAL_CODE; ?></td>
			<td><input type="text" name="zip" size="20"/> *</td>
		</tr>
		<tr>
			<td><?php echo PHONE_1; ?></td>
			<td><input type="text" name="phone" size="20"/> *</td>
		</tr>
		<tr>
			<td><?php echo PHONE_2; ?></td>
			<td><input type="text" name="alt_phone" size="20"/></td>
		</tr>
		<tr>
			<td><?php echo EMAIL; ?></td>
			<td><input type="text" name="email" size="20"/></td>
		</tr>
		<tr>
			<td><?php echo COMMENTS; ?></td>
			<td><input type="text" name="notes" size="20"/></td>
		</tr>
		<TR>
			<TD colspan="2" style="text-align:center;padding:10px;">
				<button type="submit" class="styled">
						<img src="images/stores.png" class="icon" /> <?php echo CREATION_OF_STORE; ?>
				</button>
			</TD>
		</TR>
	</TABLE>
</form>
<script language="JavaScript" type="text/javascript"
    xml:space="preserve">//<![CDATA[
  var frmvalidator  = new Validator("new-store");
  frmvalidator.EnableOnPageErrorDisplaySingleBox();
  frmvalidator.EnableMsgsTogether();
 
  frmvalidator.addValidation("store_id","req","<?php echo NOT_ENTERED_STORE_IDENTIFIER; ?>");
  frmvalidator.addValidation("store_id","maxlen=20","<?php echo MAX_DIGITS_FOR_STORE_IDENTIFIER; ?>");
  
  frmvalidator.addValidation("afm","req","<?php echo NOT_ENTERED_STORE_TIN; ?>");
  frmvalidator.addValidation("afm","numeric","<?php echo STORE_TIN_NUMERIC_ONLY; ?>");
  
  frmvalidator.addValidation("name","req","<?php echo NOT_ENTERED_RESPONSIBLE_PERSON_NAME; ?>");
  frmvalidator.addValidation("name","maxlen=254","<?php echo RESPONSIBLE_PERSON_NAME_MAX_LENGTH; ?>");
  frmvalidator.addValidation("name","alpha_s","<?php echo RESPONSIBLE_PERSON_NAME_CHARS; ?>");
  
  frmvalidator.addValidation("surname","req","<?php echo NOT_ENTERED_RESPONSIBLE_PERSON_SURNAME; ?>");
  frmvalidator.addValidation("surname","maxlen=254","<?php echo RESPONSIBLE_PERSON_SURNAME_MAX_LENGTH; ?>");
  frmvalidator.addValidation("surname","alpha_s","<?php echo RESPONSIBLE_PERSON_SURNAME_CHARS; ?>");
  
  frmvalidator.addValidation("street","req","<?php echo NOT_ENTERED_STORE_ADDRESS; ?>");
  frmvalidator.addValidation("street","maxlen=254","<?php echo STORE_ADDRESS_MAX_LENGTH; ?>");
  
  frmvalidator.addValidation("city","req","<?php echo NOT_ENTERED_STORE_CITY; ?>");
  frmvalidator.addValidation("city","maxlen=254","<?php echo STORE_CITY_MAX_LENGTH; ?>");
  frmvalidator.addValidation("city","alpha_s","<?php echo STORE_CITY_CHARS_ONLY; ?>");
  
  frmvalidator.addValidation("country","req","<?php echo NOT_ENTERED_STORE_COUNTRY; ?>");
  frmvalidator.addValidation("country","maxlen=254","<?php echo STORE_COUNTRY_MAX_LENGTH; ?>");
  frmvalidator.addValidation("country","alpha_s","<?php echo STORE_COUNTRY_CHARS_ONLY; ?>");
  
  frmvalidator.addValidation("zip","req","<?php echo NOT_ENTERED_STORE_ZIP; ?>");
 frmvalidator.addValidation("zip","maxlen=6","<?php echo STORE_ZIP_MAX_DIGITS; ?>");
 frmvalidator.addValidation("zip","numeric","<?php echo STORE_ZIP_NUMERIC_ONLY; ?>");
  
  frmvalidator.addValidation("phone","req","<?php echo NOT_ENTERED_STORE_PHONE; ?>");
  frmvalidator.addValidation("phone","numeric","<?php echo STORE_PHONE_NUMERIC_ONLY; ?>");
  
  frmvalidator.addValidation("alt_phone","numeric","<?php echo CUSTOMER_PHONE_NUMERIC_ONLY; ?>");
  
  frmvalidator.addValidation("email", "maxlen=254", STORE_EMAIL_MAX_LENGTH);
  frmvalidator.addValidation("email", "email", EMAIL_INVALID_FORMAT);
  
 frmvalidator.addValidation("notes", "maxlen=254", STORE_NOTES_MAX_LENGTH);  
  //]]></script>
<p class="main"><?php echo FIELDS_WITH_ARE_MANDATORY; ?></p>
</div>

</body>
</html>
