<?php
    // Set headers to prevent caching
    header("Pragma: no-cache");
    header("Cache-Control: no-cache, must-revalidate");
    header("Expires: Mon, 26 Jul 1997 05:00:00 GMT");

    // Include necessary files
    require_once('auth.php');
    require_once('config.php');
    require('admin.php');
    require('header.php');
?>

<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head>
    <meta http-equiv="content-type" content="text/html;charset=utf-8" />
    <title><?php echo CREATE_OFFER_TITLE; ?></title>
    <link href="styles.css" rel="stylesheet" type="text/css" />
    <link rel="shortcut icon" href="images/favicon.ico" type="image/x-icon">
    <link rel="icon" href="images/favicon.ico" type="image/x-icon" />
    <meta http-equiv="Cache-Control" content="no-cache, no-store, must-revalidate">
    <meta http-equiv="Pragma" content="no-cache">
    <meta http-equiv="Expires" content="0">
</head>

<body>
    
<?php headerDiv(); ?>

<div class="main">
    <h1><?php echo CREATE_OFFER_TITLE; ?></h1>
    
    <?php
    // Establish a database connection using mysqli
    $link = mysqli_connect(DB_HOST, DB_USER, DB_PASSWORD, DB_DATABASE);

    // Check connection
    if (!$link) {
        die(ERROR_DATABASE_CONNECTION_FAILURE);
    }

    // Set character set to UTF-8
    mysqli_set_charset($link, 'utf8');

    // Check for required POST fields
    foreach (["prize_points", "from_date", "till_date", "prize_msg"] as $field) {
        if (empty($_POST[$field])) {
            echo '<p class="main">' . REQUIRED_ELEMENTS_EMPTY . '</p>';
            exit();
        }
    }

    // Validate and format dates
    $prize_points = $_POST['prize_points'];

    $from_date = validateAndFormatDate($_POST['from_date']);
    if (!$from_date) {
        echo '<p class="main">' . OFFER_START_DATE_INVALID . '</p>';
        exit();
    }

    $till_date = validateAndFormatDate($_POST['till_date']);
    if (!$till_date) {
        echo '<p class="main">' . OFFER_END_DATE_INVALID . '</p>';
        exit();
    }

    // Escape user input for security
    $customer_custom = !empty($_POST['customer_custom']) ? mysqli_real_escape_string($link, $_POST['customer_custom']) : "NULL";
    $sms_notify = $_POST['sms_notify'];
    $prize_msg = mysqli_real_escape_string($link, $_POST['prize_msg']);

    // Insert data into the database
    $insertQuery = "INSERT INTO prizes (`prize_points`, `prize_msg`, `from_date`, `till_date`, `customer_custom`, `sms_notify`)
                    VALUES ('$prize_points', '$prize_msg', '$from_date', '$till_date', $customer_custom, $sms_notify);";

    $result = mysqli_query($link, $insertQuery);
    if (!$result) {
        die(mysqli_error($link));
    }

    // Display success message
    echo '<p class="main">' . OFFER_SUCCESSFULLY_ENTERED . '<br />';
    echo '<br />' . POINTS_FOR_OFFER_ACQUISITION . ' ' . $prize_points;
    echo '<br />' . OFFER_MESSAGE . ' ' . htmlspecialchars($prize_msg);
    echo '<br />' . FROM_LABEL . ' ' . date("d/m/Y", strtotime($from_date));
    echo '<br />' . TILL_LABEL . ' ' . date("d/m/Y", strtotime($till_date));
    echo '<br />' . SMS_LABEL . ' ' . ($sms_notify ? YES_LABEL : NO_LABEL);
    echo '<br />' . MEMBER_CATEGORY_LABEL;

    if ($customer_custom == "NULL") {
        echo ALL_LABEL;
    } else {
        for ($i = 1; $i <= CUSTOM_FIELDS_NUM; $i++) {
            if ($customer_custom == $i) {
                echo $_SESSION['SESS_CUSTOM_FIELD' . $i];
                break;
            }
        }
    }
    echo '</p>';
    ?>
</div>
</body>
</html>

<?php
// Helper function to validate and format date
function validateAndFormatDate($date) {
    $d = DateTime::createFromFormat('Y/m/d', $date);
    $isValid = $d && $d->format('Y/m/d') === $date;
    return $isValid ? $d->format('Y-m-d') : false;
}
?>
