<?php

require_once './services/Payment3DSService.php';
require_once './services/StripePayment3DSService.php';

/**
 * Description of Payment3DSFactory
 *
 * @author Kyriakopoulos George
 */
class Payment3DSFactory {
    
    /**
     * creates a Payment3DSService given the payment provider
     * 
     * @param string $provider Either 'stripe'
     * @return Payment3DSService
     */
    static function create($provider) {
        if ($provider != 'stripe') {
            throw new Exception('Only stripe is supported!');
        }
        // default
        return new StripePayment3DSService();
    }
}
