<?php

require_once 'PromotionClass.php';
require_once 'config.php';

class Dao {

    private $connection;

    function __construct($connection) {
        $this->connection = $connection;
    }

    public function addTokenToDB($customer_id, $androidToken) {

        // Βάζουμε το Token που μας στέλνει το android στην db
        $sql = "UPDATE customers SET token_id= :androidToken " . "WHERE customer_id= :customerId ;";

        $stmt = $this->connection->prepare($sql);
        $stmt->bindParam(':customerId', $customer_id);
        $stmt->bindParam(':androidToken', $androidToken);
        $stmt->execute();
    }

    public function getAllTokens() {
        $sql = "SELECT token_id FROM `customers` WHERE token_id is not null";
        $stmt = $this->connection->prepare($sql);
        $stmt->execute();
        $arrayOfTokens = $stmt->fetchAll();
        return $arrayOfTokens;
    }

    //21.5.2019
    public function getTokensFromCategory($categoryOfPromotion){
        if($categoryOfPromotion != "all"){
            $sql = "SELECT token_id from customers WHERE $categoryOfPromotion = 'y'";
        }else{
            $sql = "SELECT token_id from customers";
        }
          
        $stmt = $this->connection->prepare($sql);
        $stmt->execute();
        $arrayOfTokens = $stmt->fetchAll();
        return $arrayOfTokens;
    }
    
    
    public function userIsInCategory($id, $category) {
        if($category != "all"|| $category != ""){
            $sql = "SELECT id from customers WHERE customer_id = $id AND $category = 'y'";
        }else{
            return true;
        }
        
          
        $stmt = $this->connection->prepare($sql);
        $stmt->execute();
        $customer = $stmt->fetchAll();
        if(!empty($customer)) {
            return true;
        }
        
        return false;
    }

    public function getOneToken($customer_id) {
        $sql = "SELECT phone,token_id from customers WHERE \n" . "`customer_id`=:customerId " . "&& token_id is not NULL && token_id!=\"\"";

        $stmt = $this->connection->prepare($sql);
        $stmt->bindParam(':customerId', $customer_id);
        $stmt->execute();
        $resipientArray = $stmt->fetchAll();
        return $resipientArray;
    }

    public function writeTosms_history($group, $message, $recipients) {
        $this->connection->exec('set names utf8');
        $sql = "INSERT INTO `sms_history`(`group`,`message`,`recipients`) " . "VALUES (\"$group\",:message,$recipients)";

        $stmt = $this->connection->prepare($sql);
        $stmt->bindParam(':message', $message);
        $stmt->execute();
    }

    public function getPhonesFromDBthatHaveFirebaseToken($allPhones)
    {
        for ($i = 0; $i < count($allPhones); $i ++) {
            $allPhones[$i] = substr($allPhones[$i], 2, strlen($allPhones[$i]));
            $allPhones[$i] = '"' . $allPhones[$i] . '"';
        }
        $phones = implode(',', $allPhones);
        

        $sql = "SELECT phone,token_id, firebase_web_token FROM customers WHERE phone IN ($phones)";
        $this->connection->exec('set names utf8');
        $result = $this->connection->query($sql);
        $phonesWithFirebaseToken = array();
        foreach ($result as $row) {
            $phoneKey = SMS_COUNTRY_CODE.$row['phone'];
            $firebaseToken = [$row['token_id'], $row['firebase_web_token']]; //$firebaseToken = $row['token_id];
            $phonesWithFirebaseToken[$phoneKey] = $firebaseToken;
        }
        
        return $phonesWithFirebaseToken;
    }

    /**
     *
     * @param string $table
     *            This is either from the wifi table or beacon table
     * @return array Returns the customers that passed by but not registered.
     */
    public function getNotRegisteredCustomers($table) {
        $sql = "SELECT distinct(customer_id) AS `customer_id` \n" . "FROM newmedia_visitsdb.$table WHERE customer_id NOT IN \n" . "(SELECT token_id FROM customers)";
        $stmt = $this->connection->prepare($sql);
        $stmt->execute();

        $notRegisteredCustomers = [];
        while ($result = $stmt->fetch()) {
            $notRegisteredCustomers[] = $result["customer_id"];
        }
        return $notRegisteredCustomers;
    }

    public function getPromotions() {
        $sql = "SELECT * FROM `Promotions` \n";
        $this->connection->exec('set names utf8');
        $stmt = $this->connection->prepare($sql);

        $stmt->execute();
        $promotions = array();
        $i = 0;
        while ($result = $stmt->fetch()) {
            $promotions[$i] = new PromotionClass($result['id'], $result['title'], $result['body'], $result['entryDate'], $result['expireDateOfPromotion'],$result['category']);
           // echo "<br>".$result['category']."<br>";
           // echo "<br>".$promotions[$i]->getCategory()."<br>";
            $i ++;
        }
        return $promotions;
    }

    /**
     * @param string $promotionID
     *  @param string $storeID
     */
    public function deletePromotionClassFromDB($promotionID) {
        $sql = "DELETE FROM Promotions WHERE id = :id";
        $stmt = $this->connection->prepare($sql);


        $stmt->bindParam(":id", $promotionID);

        try {
            $stmt->execute();
        } catch (Exception $ex) {
            echo "cant delete Promotion";
        } finally {
            $stmt->closeCursor();
        }
    }

    /**
     * @param PromotionClass $promotion
     */
    public function savePromotionClassToDB($promotion) {
        $sql = "INSERT INTO `Promotions`( `title`, `body`,`expireDateOfPromotion`,`category`)\n" .
                " VALUES (:title,:body,date(:expireDateOfPromotion),:category)";
                $this->connection->exec('set names utf8');
        $stmt = $this->connection->prepare($sql);


        $title = $promotion->getTitle();
        $body = $promotion->getBody();
        $expireDateOfPromotion = $promotion->getExpireDate();
        $category = $promotion->getCategory();



        $stmt->bindParam(":title", $title);
        $stmt->bindParam(":body", $body);
        $stmt->bindParam(":expireDateOfPromotion", $expireDateOfPromotion);
        $stmt->bindParam(":category", $category);

        try {
            $stmt->execute();
        } catch (Exception $ex) {
            echo "cant save Promotion" . $ex;
            exit();
        } finally {
            $stmt->closeCursor();
        }
    }

    public function getNextPromotionID() {
        $sql = "SELECT `AUTO_INCREMENT`
                FROM  INFORMATION_SCHEMA.TABLES
                WHERE TABLE_SCHEMA = " . "'" . DB_DATABASE . "'" .
                " AND   TABLE_NAME   = 'Promotions';";
        $stmt = $this->connection->prepare($sql);
        try {

            $stmt->execute();
            $result = $stmt->fetch();
            return $result['AUTO_INCREMENT'];
        } catch (Exception $ex) {
            echo 'Error getting Notification History!</br>';
            exit();
        } finally {
            $stmt->closeCursor();
        }
    }

    public function getMessagesByPhone($phone) {
        //Φέρνει μηνύματα δύο μηνών και μετά
        $sql = "SELECT `message`,`senddate` FROM `sms_history` WHERE (sms_history.group=\"push-message\" OR sms_history.group=\"push-group\") and recipients=:phone and `senddate` >= DATE_ADD(NOW(), INTERVAL -10 DAY) ORDER BY  senddate desc ";
        $stmt = $this->connection->prepare($sql);
        $stmt->bindParam(":phone", $phone);
        try {
            $this->connection->exec("SET CHARACTER SET utf8");
            $stmt->execute();
            return $stmt->fetchAll();
        } catch (Exception $ex) {
            echo "error with messages" . $ex;
            exit();
        } finally {
            $stmt->closeCursor();
        }
    }

    public function saveToSmsHistory($group, $phones, $msgText) {

        $sql = "INSERT INTO `sms_history`(`group`, `message`, `recipients`) VALUES (:group,:msgText,:phone) ";
        $stmt = $this->connection->prepare($sql);
        try {
            foreach ($phones as $phone) {
                
                $phone = substr($phone,2,10);
                $stmt->bindParam(":group", $group);
                $stmt->bindParam(":msgText", $msgText);
                $stmt->bindParam(":phone", $phone);
                $stmt->execute();
                
            }
        } catch (Exception $ex) {
            echo $ex;
        } finally {
            $stmt->closeCursor();
        }
    }

    public function getNotExpiredPromotions() {
        $sql = "SELECT * FROM `Promotions` \n"
                . "WHERE expireDateOfPromotion >= DATE(NOW()) or expireDateOfPromotion ='0000-00-00' order by entryDate desc ;";
                $this->connection->exec('set names utf8');
        $stmt = $this->connection->prepare($sql);

        try {
            $stmt->execute();
            $promotions = array();
            $i = 0;
            while ($result = $stmt->fetch()) {
             $promotions[$i] = new PromotionClass($result['id'], $result['title'], $result['body'], $result['entryDate'], $result['expireDateOfPromotion'], $result['category']);
                $i++;
            }
            return $promotions;
        } catch (Exception $ex) {
            echo 'Error finding Promotions';
        } finally {
            $stmt->closeCursor();
        }
    }
    
    /**
     * Retrieving the last promotion inserted in the given category
     * @param string $category the category as saved in database
     * @return array containing one Promotion
     */
    public function getLastPromotionByCategory($category) {
        $sql = "SELECT * FROM `Promotions` \n"
                . "WHERE (expireDateOfPromotion >= DATE(NOW()) or expireDateOfPromotion ='0000-00-00') AND category = :category order by id desc LIMIT 1;";
        $this->connection->exec('set names utf8');
        $stmt = $this->connection->prepare($sql);
        $stmt->bindParam(":category", $category);

        try {
            $stmt->execute();
            $promotions = array();
            $result = $stmt->fetch();
            $promotions[] = new PromotionClass($result['id'], $result['title'], $result['body'], $result['entryDate'], $result['expireDateOfPromotion'], $result['category']);
   
            return $promotions;
        } catch (Exception $ex) {
            echo 'Error finding Promotions';
        } finally {
            $stmt->closeCursor();
        }
    }

}

?>
