<?php
// link_xloyalty.php
// Manually link a Clover merchant to an xLoyalty account ID

require_once __DIR__ . '/db.php';

$merchant_id = isset($_GET['merchant_id']) ? $_GET['merchant_id'] : '';

// Handle form POST
if ($_SERVER['REQUEST_METHOD'] === 'POST') {

    $merchant_id = isset($_POST['merchant_id']) ? trim($_POST['merchant_id']) : '';
    $account_id  = isset($_POST['account_id']) ? trim($_POST['account_id']) : '';

    if ($merchant_id === '' || $account_id === '') {
        $error = "Merchant ID and xLoyalty Account ID are required.";
    } else {

        // Update mapping in clover_merchants
        $stmt = $pdo->prepare("
            UPDATE clover_merchants
            SET xloyalty_account_id = ?, updated_at = NOW()
            WHERE merchant_id = ?
        ");
        $stmt->execute(array($account_id, $merchant_id));

        $success = "Clover merchant <b>" . htmlspecialchars($merchant_id) .
                   "</b> linked to xLoyalty account <b>" . htmlspecialchars($account_id) . "</b>.";

        // Reload current mapping
        $stmt = $pdo->prepare("
            SELECT merchant_id, xloyalty_account_id
            FROM clover_merchants
            WHERE merchant_id = ?
        ");
        $stmt->execute(array($merchant_id));
        $row = $stmt->fetch(PDO::FETCH_ASSOC);
    }
} else {
    // GET: load existing mapping (if any)
    $row = null;
    if ($merchant_id !== '') {
        $stmt = $pdo->prepare("
            SELECT merchant_id, xloyalty_account_id
            FROM clover_merchants
            WHERE merchant_id = ?
        ");
        $stmt->execute(array($merchant_id));
        $row = $stmt->fetch(PDO::FETCH_ASSOC);
    }
}

$currentAccountId = ($row && !empty($row['xloyalty_account_id']))
    ? $row['xloyalty_account_id']
    : '';
?>
<!doctype html>
<html>
<head>
    <meta charset="utf-8">
    <title>Link xLoyalty Account</title>
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <style>
        body {
            font-family: Arial, Helvetica, sans-serif;
            background: #f3f4f6;
            margin: 0;
            padding: 0;
            color: #111827;
        }
        .wrapper {
            max-width: 640px;
            margin: 0 auto;
            padding: 16px;
        }
        .card {
            background: #ffffff;
            border-radius: 8px;
            padding: 16px 20px;
            box-shadow: 0 1px 3px rgba(15, 23, 42, 0.08);
            margin-top: 16px;
        }
        h1 {
            font-size: 18px;
            margin-bottom: 8px;
        }
        .field {
            margin-bottom: 10px;
        }
        .field label {
            display: block;
            font-size: 13px;
            margin-bottom: 2px;
        }
        .field input {
            width: 100%;
            padding: 6px 8px;
            border-radius: 4px;
            border: 1px solid #d1d5db;
            font-size: 14px;
        }
        .btn {
            display: inline-block;
            padding: 8px 14px;
            border-radius: 6px;
            border: none;
            background: #2563eb;
            color: #ffffff;
            font-size: 14px;
            cursor: pointer;
        }
        .msg-success {
            background: #ecfdf3;
            border: 1px solid #bbf7d0;
            padding: 8px 10px;
            border-radius: 6px;
            margin-bottom: 10px;
            font-size: 13px;
        }
        .msg-error {
            background: #fef2f2;
            border: 1px solid #fecaca;
            padding: 8px 10px;
            border-radius: 6px;
            margin-bottom: 10px;
            font-size: 13px;
        }
        .hint {
            font-size: 12px;
            color: #6b7280;
        }
    </style>
</head>
<body>
<div class="wrapper">

    <div class="card">
        <h1>Link Clover merchant to xLoyalty account</h1>
        <p class="hint">
            Here you can manually assign the xLoyalty account ID that should be used
            for this Clover merchant.
        </p>

        <?php if (!empty($success)): ?>
            <div class="msg-success"><?php echo $success; ?></div>
        <?php endif; ?>

        <?php if (!empty($error)): ?>
            <div class="msg-error"><?php echo htmlspecialchars($error); ?></div>
        <?php endif; ?>

        <form method="post">
            <div class="field">
                <label for="merchant_id">Clover Merchant ID</label>
                <input type="text"
                       id="merchant_id"
                       name="merchant_id"
                       value="<?php echo htmlspecialchars($merchant_id); ?>" />
            </div>

            <div class="field">
                <label for="account_id">xLoyalty Account ID</label>
                <input type="text"
                       id="account_id"
                       name="account_id"
                       value="<?php echo htmlspecialchars($currentAccountId); ?>"
                       placeholder="Internal xLoyalty Account ID" />
            </div>

            <button type="submit" class="btn">Save link</button>
        </form>

        <?php if ($currentAccountId !== ''): ?>
            <p class="hint">
                Currently linked to xLoyalty account:
                <strong><?php echo htmlspecialchars($currentAccountId); ?></strong>
            </p>
        <?php endif; ?>
    </div>

</div>
</body>
</html>
