<?php
require_once __DIR__ . '/config.php';

function clover_apply_discount($merchantId, $orderId, $accessToken, $discountEuro, $points) {

    $url = clover_base_url() . "/v3/merchants/" . $merchantId . "/orders/" . $orderId . "/discounts";

    $payload = json_encode(array(
        "name"   => "xLoyalty Redeem (" . $points . " pts)",
        "amount" => (int)round($discountEuro * 100)
    ));

    $opts = array(
        'http' => array(
            'method'  => 'POST',
            'header'  => "Authorization: Bearer " . $accessToken . "\r\nContent-Type: application/json\r\n",
            'content' => $payload
        )
    );

    $ctx = stream_context_create($opts);
    $resp = file_get_contents($url, false, $ctx);

    return $resp;
}
?>
