<?php
error_reporting(E_ALL);
ini_set('display_errors', 1);
header('Content-Type: application/json; charset=utf-8');

$raw   = file_get_contents('php://input');
$input = json_decode($raw, true);

if ( ! is_array($input) ) {
    echo json_encode(['ok' => false, 'code' => 'invalid_payload', 'message' => 'No valid JSON payload.']);
    exit;
}

// Example input: {"product":"xloyalty-pro","license":"demo-1234-5678","domain":"example.com","action":"activate"}

$product = $input['product'] ?? '';
$license = trim($input['license'] ?? '');
$domain  = strtolower($input['domain'] ?? '');
$action  = $input['action'] ?? 'check';

// --- DEMO DATABASE (replace with real DB calls)
$licenses = [
    'demo-1234-5678' => [
        'plan' => 'Pro',
        'bound_domain' => null,
        'expires' => '2026-12-31',
        'status' => 'active'
    ],
    'expired-0000' => [
        'plan' => 'Pro',
        'bound_domain' => null,
        'expires' => '2024-12-31',
        'status' => 'expired'
    ],
];

// --- Security check (HMAC optional) ---
$shared_secret = 'YOUR-SHARED-SECRET-HERE';
if (!empty($shared_secret)) {
    $expected = hash_hmac('sha256', file_get_contents('php://input'), $shared_secret);
    $received = $_SERVER['HTTP_X_XLP_SIGNATURE'] ?? '';
    if (!hash_equals($expected, $received)) {
        echo json_encode(['ok' => false, 'code' => 'bad_signature', 'message' => 'Invalid signature.']);
        exit;
    }
}

// --- Core logic ---
if (!isset($licenses[$license])) {
    echo json_encode(['ok' => false, 'code' => 'not_found', 'message' => 'Invalid license key.']);
    exit;
}

$record = $licenses[$license];

// handle expired
if (strtotime($record['expires']) < time()) {
    echo json_encode(['ok' => false, 'status' => 'expired', 'message' => 'License expired on '.$record['expires']]);
    exit;
}

// handle binding
if ($record['bound_domain'] && $record['bound_domain'] !== $domain) {
    echo json_encode(['ok' => false, 'status' => 'bound_elsewhere', 'message' => 'License already bound to '.$record['bound_domain']]);
    exit;
}

// handle actions
switch ($action) {
    case 'activate':
        $record['bound_domain'] = $domain;
        echo json_encode([
            'ok' => true,
            'status' => 'active',
            'domain' => $domain,
            'plan' => $record['plan'],
            'expires' => $record['expires'],
            'message' => 'License bound successfully.'
        ]);
        break;

    case 'deactivate':
        $record['bound_domain'] = null;
        echo json_encode([
            'ok' => true,
            'status' => 'inactive',
            'domain' => '',
            'message' => 'License released.'
        ]);
        break;

    default:
        echo json_encode([
            'ok' => true,
            'status' => $record['status'],
            'domain' => $record['bound_domain'] ?? '',
            'plan' => $record['plan'],
            'expires' => $record['expires'],
            'message' => 'License valid and active.'
        ]);
        break;
}
