<?php
require_once __DIR__ . '/../libs/net2020/stripe-sdk/init.php';
require_once __DIR__ . '/../libs/net2020/stripe-sdk/stripe-config.php';
require_once __DIR__ . '/../account-manager81/config.php';
require_once __DIR__ . '/../libs/net2020/utils/SQLFilter.php';
require_once __DIR__ . '/../libs/net2020/DatabaseConnector.php';
require_once __DIR__ . '/../account-manager81/dao/AccountDao.php';
require_once __DIR__ . '/../account-manager81/services/LoyaltySubscriptionService.php';


// The library needs to be configured with your account's secret key.
// Ensure the key is kept out of any version control system you might be using.
$stripe = new \Stripe\StripeClient(STRIPE_CLIENT_SECRET);

$payload = @file_get_contents('php://input');
$sig_header = $_SERVER['HTTP_STRIPE_SIGNATURE'];
$event = null;
try {
  $event = \Stripe\Webhook::constructEvent(
    $payload, $sig_header, STRIPE_WEBHOOK_SECRET
  );
} catch(\UnexpectedValueException $e) {
  // Invalid payload
  http_response_code(400);
  exit();
} catch(\Stripe\Exception\SignatureVerificationException $e) {
  // Invalid signature
  http_response_code(401);
  exit();
}


  // Loyalty subscription payment succeeded
  if ($event->type ==='invoice.payment_succeeded') {
    try {
        $sender = $event->data->object->customer_email;
        $planInterval = $event->data->object->lines->data[0]->plan->interval;
        $planIntervalCount = $event->data->object->lines->data[0]->plan->interval_count;
        $period = null;
        if ($planInterval === 'month') {
            $period = $planIntervalCount;
        }
        else if ($planInterval === 'year') {
            $period = $planIntervalCount * 12;
        }
        else {
            error_log("plan interval : {$planInterval} is not supported, event: {$event->id}");
            exit();
        }
        $databaseConnector = new DatabaseConnector(DB_DATABASE, DB_USER, DB_PASSWORD, DB_HOST);
        $connection = $databaseConnector->getConnection();
        $accountDao = new AccountDao($connection);
        $result = $accountDao->findAll((new SQLFilter("billing_email = $sender")));
    
        if (count($result) == 0) {
            http_response_code(402);
            error_log("account not found for stripe event: {$event->id}");
            exit();
        }
    
        $account = $result[0];
        $loyaltySubscriptionService = new LoyaltySubscriptionService($accountDao);
        // Update the subscription, plus 1 hour until the invoice is automatically sent
        $loyaltySubscriptionService->updateSubscription($account, $period, 1);
      } catch (\Throwable $e) { // For PHP 7
        http_response_code(500);
        error_log("Error during proccessing the stripe event: {$event->id}");
      } catch (\Exception $e) { // For PHP 5
        http_response_code(501);
        error_log("Error during proccessing the stripe event: {$event->id}");
      }

  }

http_response_code(200);