<?php

require_once "SubscriptionService.php";
require_once __DIR__ . "/../dao/AccountDao.php";
require_once __DIR__ . "/../../libs/net2020/utils/SQLFilter.php";

/**
 * Updates the expiration date for a loyalty customer
 */
class LoyaltySubscriptionService implements SubscriptionService {

    /**
     * @var AccountDao 
     */
    private $accountDao;

    /**
     * 
     * @param AccountDao $accountDao
     */
    public function __construct($accountDao) {
        $this->accountDao = $accountDao;
    }

    /**
     * Updates the expiration period for the current account
     * if the current expiration period has passed then the new
     * one will be the current date plus the given months. For
     * future expiration date the new date will be equal to the 
     * existing expiration plus the months and optionally the hours
     * @param Account $account
     * @param int $months
     * @param int $hours How many hours to add, can be null
     * @return DateTime The new expiration date
     */
    public function updateSubscription($account, $months, $hours = null) {

        if ($months < 0 || !$account) {
            return null;
        }

        
        $accountSubscriptionEndDate = strtotime($account->getSubscription_end_date());
        $now = time();

        if ($accountSubscriptionEndDate < $now) {
            $newExpirationDate = date('Y-m-d H:i:s', strtotime("+$months months", $now));
        } else {
            $newExpirationDate = date('Y-m-d H:i:s', strtotime("+$months months", $accountSubscriptionEndDate));
        }

        if ($hours != null) {
            $newExpirationDate = date('Y-m-d H:i:s', strtotime("+$hours hours", strtotime($newExpirationDate)));
        }

        $account->setSubscription_end_date($newExpirationDate);
        $account->setSubscription_update_date(date('Y-m-d H:i:s', $now));
        $this->accountDao->save($account);
        
        return $newExpirationDate;
    }
}
