<?php
require_once('config.php');

function sendSMS ($phoneNoRecipients = array(), $msgText) {

    $phoneNoRecipients = array_unique($phoneNoRecipients);

    foreach($phoneNoRecipients as $key => $phone) {
        if (strlen($phone) != 12 || substr($phone, 0, 4) != "3069") {
            unset($phoneNoRecipients[$key]);
        }
    }

    $errors = 0;
    if (!empty($phoneNoRecipients)) {
        $url = "http://" . SMS_GW_IP . ":" . SMS_GW_PORT;

        if(SMS_BATCH_SPLIT_REQUESTS) {
            /* Sends multiple requests with 50 recipients each */
            $batch = array();
            foreach ($phoneNoRecipients as $phone) {
                $batch[] = $phone;

                if (count($batch) % 2 == 0) {
                    $params = array("to" => implode(",", $batch), "text" => urlencode($msgText) );
                    $response = curlSendSMS($url, $params);
                    $errors += substr_count($response, "ERROR");
                    if(!$response) {
                         return 0;
                    }
                    curlSendResponse($response);
                    $batch = array();
                }
            }

            if (!empty($batch)) {
                $params = array("to" => implode(",", $batch), "text" => urlencode($msgText) );
                $response = curlSendSMS($url, $params);
                $errors += substr_count($response, "ERROR");
                if(!$response) {
                    return 0;
                }
                curlSendResponse($response);
            }
        }
        else {
            /* Sends one request with all recipients at once */
            $params = array("to" => implode(",", $phoneNoRecipients), "text" => urlencode($msgText) );
            $response = curlSendSMS($url, $params);
            $errors += substr_count($response, "ERROR");
            if(!$response) {
                return 0;
            }
            curlSendResponse($response);
        }
    }
    return count($phoneNoRecipients)-$errors;
}

function curlSendSMS($url, $params) {
//    return fakeCurlSendSMS($params);

    $params["username"] = urlencode(SMS_GW_USER);
    $params["password"] = urlencode(SMS_GW_PASS);
    $params["from"] = urlencode(SMS_FROM);

    $fields_string = "";
    foreach($params as $key => $value) {
        $fields_string .= $key.'='.$value.'&';
    }
    rtrim($fields_string, '&');

    $ch = curl_init();

    curl_setopt($ch,CURLOPT_URL, $url);
    curl_setopt($ch,CURLOPT_RETURNTRANSFER, 1);
    curl_setopt($ch,CURLOPT_POST, count($params));
    curl_setopt($ch,CURLOPT_POSTFIELDS, $fields_string);
    $response = curl_exec($ch);
    if(curl_errno($ch)) {
        curl_close($ch);
        return false;
    }
    curl_close($ch);

    return $response;
}

function curlSendResponse($response) {
    $url = SMS_RESULT_URL;

    $params = array("result" => $response);
    $fields_string = "";
    foreach($params as $key => $value) {
        $fields_string .= $key.'='.$value.'&';
    }
    rtrim($fields_string, '&');

    $ch = curl_init();
    curl_setopt($ch,CURLOPT_URL, $url);
    curl_setopt($ch,CURLOPT_RETURNTRANSFER, 1);
    curl_setopt($ch,CURLOPT_POST, count($params));
    curl_setopt($ch,CURLOPT_POSTFIELDS, $fields_string);
    curl_exec($ch);
    curl_close($ch);
}

function fakeCurlSendSMS($params) {
    $response = "";
    if(isset($params['to'])) {
        foreach(explode(",", $params['to']) as $to) {
            $response .= "SUCCESS MessageId: ".uniqid("", true).";Recipient:".$to."<br />";
//            $response .= "ERROR:001; STATUS:Invalid username or password<br />";
        }
    }
    return $response;
/**
 * Possible responses:
 *
 * multiple recipients : "SUCCESS MessageId: 557bf16fa48d0-8441-95269;Recipient:306971234567<br />SUCCESS MessageId: 557bf16fa4ea4-7081-47246;Recipient:306972345678<br />"
 * one recipient : "SUCCESS MessageId: 5575f02a3016c-2648-59494;Recipient:306971234567"
 * error: "ERROR:001; STATUS:Invalid username or password"
 * error: "ERROR:003; STATUS:Out Of Credit"
 */
}

function returnSMS()
{
    $credits = file_get_contents(SMS_CREDITS_URL);
    $credits = json_decode($credits, true);

    return $credits['credits'];
}

function getAccountInfo()
{
    $info = file_get_contents(SMS_CREDITS_URL);
    $info = json_decode($info, true);

    return $info;
}

function getLatinText($text){
    $greek = array("Α", "Β", "Ε", "Ζ", "Η", "Ι", "Κ", "Μ", "Ν", "Ο", "Ρ", "Τ", "Υ", "Χ");
    $latin = array("A", "B", "E", "Z", "H", "I", "K", "M", "N", "O", "P", "T", "Y", "X");
    return str_replace($greek, $latin, $text);
}

?>
