<?php
	header("Pragma: no-cache");
    header("Cache: no-cache");
    header("Cache-Control: no-cache, must-revalidate");
    header("Expires: Mon, 26 Jul 1997 05:00:00 GMT");

	require_once('auth.php');
	require_once('config.php');
	require_once('sendSMS.php');
	require('header.php');

?>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head>
<meta http-equiv="content-type" content="text/html;charset=utf-8" />
<title>Προεπισκόπιση μαζικής αποστολής μηνύματος</title>
<link href="styles.css" rel="stylesheet" type="text/css" />
<link rel="shortcut icon" href="images/favicon.ico" type="image/x-icon">
<link rel="icon" href="images/favicon.ico" type="image/x-icon" />
<meta http-equiv="Cache-Control" content="no-cache, no-store, must-revalidate">
<meta http-equiv="Pragma" content="no-cache">
<meta http-equiv="Expires" content="0">
<script type="text/javascript" language="javascript">
	function showMsg(){
		alert("Η διαδικασία της αποστολής θα διαρκέσει μερικά δευτερόλεπτα.\nΠαρακαλώ περιμένετε...");
	}
    function printDiv(store){
        var content = document.getElementById("printable");
        var pri = document.getElementById("printwindow").contentWindow;
        pri.document.open();
        pri.document.write('<div><img src="images/logo.png" /><br /><br />');
        pri.document.write(content.innerHTML);
        pri.document.write('</div>');
        pri.document.close();
        pri.focus();
        pri.print();
    }
</script>
</head>

<body>

<?php headerDiv();?>

	<div class="main">
		<h1>Προεπισκόπιση Marketing</h1>
        <div id="printable" >
<?php
	$error = false;
	//Connect to mysql server
	$link = mysql_connect(DB_HOST, DB_USER, DB_PASSWORD);
	if(!$link) {
		die('Αποτυχία σύνδεσης με το διακομιστή της βάσης δεδομένων : '.mysql_error());
	}

	//Select database
	$db = mysql_select_db(DB_DATABASE);
	if(!$db) {
		die('Αποτυχία σύνδεσης με τη βάση δεδομένων');
	}

	mysql_query("SET character_set_results = 'utf8', character_set_client = 'utf8', character_set_connection = 'utf8', character_set_database = 'latin1', character_set_server = 'latin1'", $link)
	or die(mysql_error());

	$campaigntype = "1";
	if(isset($_POST['campaigntype']))
		$campaigntype = $_POST['campaigntype'];

	$days = "1";
	if(isset($_POST['days'.$campaigntype]) && intval($_POST['days'.$campaigntype]) != "")
		$days = intval($_POST['days'.$campaigntype]);

	$visits = "1";
	if(isset($_POST['visits'.$campaigntype]) && intval($_POST['visits'.$campaigntype]) != "")
		$visits = intval($_POST['visits'.$campaigntype]);

    $smsMsg = "";
	if(isset($_POST['msg'])){
		if ($_POST['msg'] != ""){
			$smsMsg = getLatinText($_POST['msg']);
		}
		else{
			$error = true;
		}
	}
	else{
		$error = true;
	}

	$pastSeconds = time() - 86400*$days;
	$past = date("Y-m-d 00:00:01", $pastSeconds);
	$dateToDisplay = date("d/m/Y", $pastSeconds);

	if ($campaigntype == "1") {
        $visits2 = "0";
        if(isset($_POST['visits1_2']) && intval($_POST['visits1_2']) != "")
            $visits2 = intval($_POST['visits1_2']);

        echo '<p class="main">Πελάτες που έχουν να εμφανιστούν στο κατάστημα '.$days.' ημέρες και στο παρελθόν είχαν κάνει από '.$visits2.' έως '.$visits.' επισκέψεις </p>';

        $qry = "
            SELECT `customers`.`customer_id`, `customers`.`name`, `customers`.`surname`, `customers`.`phone`,
            SUM(IF(`t`.`date` < '".$past."', 1, 0)) AS `beforecounter`,
            SUM(IF(`t`.`date` >= '".$past."', 1, 0)) AS `aftercounter`,
            SUM(`t`.`money`) AS `money`
            FROM `customers`
            INNER JOIN `transactions` AS `t` ON `t`.`customer_auto_id` = `customers`.`id`";
        if(!$error) {
            $qry .= " WHERE `customers`.`sms` = 1 ";
        }
        $qry .= "
GROUP BY `customers`.`id`
HAVING `beforecounter` <= ".$visits." AND `beforecounter` >= ".$visits2." AND `aftercounter` = 0"
;
	}
	elseif ($campaigntype == "2") {
        $visits2 = "10";
        if(isset($_POST['visits2_2']) && intval($_POST['visits2_2']) != "")
            $visits2 = intval($_POST['visits2_2']);

        echo '<p class="main">Πελάτες που έκαναν από '.$visits.' εώς '.$visits2.' επισκέψεις τις τελευταίες '.$days.' ημέρες</p>';

		$qry = "
            SELECT `customers`.`customer_id`, `customers`.`name`, `customers`.`surname`, `customers`.`phone`,
            SUM(IF(`t`.`date` < '".$past."', 1, 0)) AS `beforecounter`,
            SUM(IF(`t`.`date` >= '".$past."', 1, 0)) AS `aftercounter`,
            SUM(IF(`t`.`date` >= '".$past."', `t`.`money`, 0)) AS `money`,
            SUM(`t`.`money`) AS `total_money`
            FROM `customers`
            INNER JOIN `transactions` AS `t` ON `t`.`customer_auto_id` = `customers`.`id`";
        if(!$error) {
            $qry .= " WHERE `customers`.`sms` = 1 ";
        }
        $qry .= " GROUP BY `customers`.`id` ";
        $percentQry = "SELECT SUM(money) AS money FROM (".$qry.") AS temp";
        $qry .= "HAVING `aftercounter` >= ".$visits." AND `aftercounter` <= ".$visits2;

        $sumResult = mysql_query($percentQry) or die(mysql_error());
        $row = mysql_fetch_array($sumResult);
        $totalMoney = $row['money'];
	}
    elseif ($campaigntype == "3") {
        echo '<p class="main">Πελάτες της ομάδας ';
        if ($visits == "1") echo "Βασικοί πελάτες";
        elseif ($visits == "2") echo "Ασημένιοι πελάτες";
        elseif ($visits == "3") echo "Χρυσοί πελάτες";
        echo '</p>';

        $qry = "
SELECT `customers`.`customer_id`, `customers`.`name`, `customers`.`surname`, `customers`.`phone`, SUM(`transactions`.`points`) AS `totalpoints`, SUM(`transactions`.`money`) AS `money`
FROM `customers`
JOIN transactions ON transactions.customer_auto_id = customers.id ";
        if(!$error) {
            $qry .= " WHERE `customers`.`sms` = 1 ";
        }
        $qry .= " GROUP BY `customers`.`id`";
        if($visits == "1") {
            $qry .= "HAVING `totalpoints` BETWEEN 0 AND ".$_SESSION['SESS_CUSTOM_CAT1']."-1";
        }elseif ($visits == "2") {
            $qry .= "HAVING `totalpoints` BETWEEN ".$_SESSION['SESS_CUSTOM_CAT1']." AND ".$_SESSION['SESS_CUSTOM_CAT2']."-1";
        }
        elseif ($visits == "3") {
            $qry .= "HAVING `totalpoints` > ".$_SESSION['SESS_CUSTOM_CAT3'];
        }
    }
    elseif ($campaigntype == "4") {
        echo '<p class="main">Πελάτες που έκαναν τζίρο πάνω από '.$visits.' €</p>';

        $qry = "
SELECT `customers`.`customer_id`, `customers`.`name`, `customers`.`surname`, `customers`.`phone`, SUM(`transactions`.`money`) AS `money`
FROM `customers`
JOIN transactions ON transactions.customer_auto_id = customers.id ";
        if(!$error) {
            $qry .= " WHERE `customers`.`sms` = 1 ";
        }
        $qry .= " GROUP BY `customers`.`id` HAVING money >= ".$visits;
        $qry .= " ORDER BY `money` DESC";
    }

//	echo $qry ;

    if($error == false) {
        echo '<p class="main">Το παρακάτω μήνυμα θα αποσταλεί στους εξής <span id="num"></span> πελάτες : </p>';
        echo '<p>'.$smsMsg.'</p>';
    }

    $phoneNumbers = array();

	$result = mysql_query($qry) or die(mysql_error());
    $sumResult = mysql_query("SELECT SUM(money) AS money FROM (".$qry.") AS temp") or die(mysql_error());
    $sumRow = mysql_fetch_array($sumResult);

    $rows = mysql_num_rows($result);
    $results = 0;
    if($rows > 0) {
        echo '<p class="main">Tζίρος: '.$sumRow['money']."€";
        if($campaigntype == "2") {
            echo " (" . round($sumRow['money'] * 100 / $totalMoney, 2) . "%)";
        }
        echo "</p>";

        if($campaigntype == "2") {
            echo '<p class="main">Συνολικός τζίρος τις τελευταίες '.$days.' μέρες: ' . $totalMoney . '€</p>';
        }

        if(ALLOW_MASSIVE_SMS_NUMBERS_EXPORT) {
            echo '<button type="submit" class="styled" onclick="document.getElementById(\'export-numbers\').submit();"><img src="images/save.png" class="icon" /> Εξαγωγη αριθμων</button>';
        }

        echo '<table class="main" cellspacing="0"  >
                <tr style="font-weight:bold;text-align:center;">
                    <td>A/A</td>
                    <td class="leftborder">Αριθμός</td>
                    <td class="leftborder">Επώνυμο</td>
                    <td class="leftborder">Όνομα</td>
                    <td class="leftborder">Τηλέφωνο</td>';
        if($campaigntype == "1" || $campaigntype == "2") {
            echo '	<td class="leftborder">Συναλλαγές<br />προ '.$dateToDisplay.'</td>
                    <td class="leftborder">Συναλλαγές<br />μετά '.$dateToDisplay.'</td>';
        }
        elseif($campaigntype == "3") {
            echo '	<td class="leftborder">Πόντοι</td>';
        }
        elseif($campaigntype == "4") {
            echo '	<td class="leftborder">Τζίρος</td>';
        }
        echo '	</tr>';

        $counter = 0;
        while($row = mysql_fetch_array($result)) {
            $phoneNumbers[] = $row['phone'];

            $results++;
            if ($counter == 0){
                    $column = "even";
                    $counter++;
            }else{
                    $column = "odd";
                    $counter = 0;
            }

            echo '
                <tr class="';
            echo $column;
            echo '">';
            echo '  <td style="text-align:center;">'.$results.'</td>
                    <td class="leftborder" style="text-align:center;">'.$row['customer_id'].'</td>
                    <td class="leftborder">'.$row['surname'].'</td>
                    <td class="leftborder">'.$row['name'].'</td>
                    <td class="leftborder">'.$row['phone'].'</td>';
            if($campaigntype == "1" || $campaigntype == "2") {
                echo '<td class="leftborder" style="text-align:center;">'.$row['beforecounter'].'</td>
                    <td class="leftborder" style="text-align:center;">'.$row['aftercounter'].'</td>';
            }
            elseif($campaigntype == "3") {
                echo '<td class="leftborder" style="text-align:center;">'.$row['totalpoints'].'</td>';
            }
            elseif($campaigntype == "4") {
                echo '<td class="leftborder" style="text-align:center;">'.$row['money'].'</td>';
            }

            echo '</tr>';
        }
        echo '</table>';
    }
    else {
        echo '<p class="main">Δε βρέθηκαν αποτελέσματα</p>';
    }

	echo '<form method="post" name="sms-campaign" id="sms-campaign" action="new-sms-campaign-exec.php">';
	echo '<input type="hidden" name="msg" id="msg" value="'.$smsMsg.'" />';
	echo '<input type="hidden" name="campaigntype" id="campaigntype" value="'.$campaigntype.'" />';
	echo '<input type="hidden" name="days'.$campaigntype.'" id="days" value="'.$days.'" />';
	echo '<input type="hidden" name="visits'.$campaigntype.'" id="visits" value="'.$visits.'" />';
    if($campaigntype == "1") {
        echo '<input type="hidden" name="visits1_2" id="visits1_2" value="' . $visits2 . '" />';
    }
    if($campaigntype == "2") {
        echo '<input type="hidden" name="visits2_2" id="visits2_2" value="' . $visits2 . '" />';
    }
	if ($error == false && ($_SESSION['SESS_ADMIN'] == "y" || $_SESSION['SESS_SMS_ENABLE_USER'] == "y")){
		echo '<button type="submit" class="styled" onclick="showMsg()"><img src="images/apply.png" class="icon" /> Aποστολή Μηνύματος</button>';
	}
	else {
        if($_SESSION['SESS_ADMIN'] != "y" && $_SESSION['SESS_SMS_ENABLE_USER'] != "y") {
            echo '<p class="main">Η αποστολή sms έχει απενεργοποιηθεί από τις ρυθμίσεις της εφαρμογής!</p>';
        }
	}
	echo '</form>';

    /* export numbers to csv */
    if(ALLOW_MASSIVE_SMS_NUMBERS_EXPORT){
        $phoneNumbers = array_unique($phoneNumbers);
        echo '<form action="export-csv-exec.php" id="export-numbers" method="post">';
        echo '<input type="hidden" name="datacomma" value="' . implode(",", $phoneNumbers) . '" />';
        echo '<input type="hidden" name="filename" value="phone_numbers_marketing" />';
        echo '<button type="submit" class="styled"><img src="images/save.png" class="icon" /> Εξαγωγη αριθμων</button>';
        echo '</form>';
    }

	echo '
	<script type="text/javascript" language="javascript">
		document.getElementById(\'num\').innerHTML = '.$results.';
	</script>';
?>
            <div class="printButton">
                <button type="button" class="styled" onclick="printDiv('<?php echo $_SESSION['SESS_STORE_ID'].'<br />'.
                    $_SESSION['SESS_STORE_STREET'].', '.$_SESSION['SESS_STORE_CITY'].
                    '<br />Τηλέφωνο : '.$_SESSION['SESS_STORE_PHONE'];?>');">
                    <img src="images/print.png" class="icon" /> Εκτύπωση</button>
            </div>
            <div style="clear:both;"></div>
        </div>
</div>

<iframe id="printwindow" frameborder="0"></iframe>

</body>
</html>
