<?php

require_once 'CredentialsDB.php';
require_once 'Customer.php';
require_once 'Transaction.php';

class Dao {
    /* Αυτήν η κλάση παίρνει δύο connection επειδή εδώ γίνονται το πάρε δώσε των βάσεων */

    private $pdoConnectionWooCommerce; //αυτό μπορώ α το πάρω από το getConnection() του DatabaseConnector 
    private $pdoConnectionLoyalty;
    private $currentWpPost; /* Αυτήν η μεταβλητή έχει το αποτέλεσμα-πίνακα των νέων συναλλαγών 
     * Τον βάζουμε σε μεταβλητή επειδή χρησιμοποιήται πολλές φορές για λόγους απόδοσεις
     */
    private $CurrentTransactionsFromPostsView;
    private $allCurrentTransactions; //Σημερινές συναλλαγές

    function __construct($pdoConnectionLoyalty, $pdoConnectionWooCommerce) {
        $this->pdoConnectionLoyalty = $pdoConnectionLoyalty;
        $this->pdoConnectionWooCommerce = $pdoConnectionWooCommerce;
    }

    function getCurrentWp2c_posts() {
        $this->pdoConnectionWooCommerce->exec("SET CHARACTER SET 'utf8'");
        $this->pdoConnectionLoyalty->exec("SET CHARACTER SET 'utf8'");

        try {




            //1)Παίρνουμε το eshop_order_id από τον πίνακα transactions στην db του loyalty
            /* -------------------------------------------------------------------------------------------------- */
            $lastCustomer = "SELECT IFNULL(max(eshop_order_id),-1) AS last_customer FROM transactions";
            $loyaltyStmt = $this->pdoConnectionLoyalty->prepare($lastCustomer);
            $loyaltyStmt->execute();
            /* παίρνουμε από τον πίνακα transaction την τελευταία
             *  συναλλαγή που πήραμε εάν είναι κενός ο transactions τότε
             * επιστεφει το ερώτημα -1
             */
            $result = $loyaltyStmt->fetch();
            $lastCustomer = $result[0];
            /* -------------------------------------------------------------------------------------------------- */




            //2)Δημιουργία του view 
            /* -------------------------------------------------------------------------------------------------- */
            $this->CurrentTransactionsFromPostsView = "NewTranscactions";
            $tablenamePosts = tablePrefix . "posts";
            //Δημιουργία του view που περιέχει τα στοιχεία που δεν έχουμε πάρει
            $queryCreateView = "CREATE OR REPLACE view NewTranscactions "
                    . "AS select wp2c_posts.id  from  $tablenamePosts where  "
                    . "$tablenamePosts.id > $lastCustomer &&"
                    . "post_status = 'wc-completed'&& "
                    . "comment_status='closed'&& "
                    . "post_type='shop_order';";
            $woocommerceStmt = $this->pdoConnectionWooCommerce->prepare($queryCreateView);
            $woocommerceStmt->execute();
            /* -------------------------------------------------------------------------------------------------- */




            //3)Παίρνουμε τα στοιχεία που έχει μέσα το view
            /* -------------------------------------------------------------------------------------------------- */
            $querySelectFromView = "select * from $this->CurrentTransactionsFromPostsView";
            //Εκτέλεσει του ερωτήματος που κάνει select στο view
            $woocommerceStmt = $this->pdoConnectionWooCommerce->prepare($querySelectFromView);
            $woocommerceStmt->execute();
            $this->currentWpPost = $woocommerceStmt->fetchAll();
            /* -------------------------------------------------------------------------------------------------- */







            //4)Εκτέλεσει του ερωτήματος που βρίσκει το order_item_id της  παραγγελίας. Τα στοιχεία αυτά τα θέλουμε στο transactions
            /* -------------------------------------------------------------------------------------------------- */
            $tablenameOrder = tablePrefix . "woocommerce_order_items";
            $queryCurrentOrderItemsWithCustomerPhone = "select order_item_id, order_id, order_item_name,meta_value as phone \n"
                    . "from wp2c_woocommerce_order_items,$this->CurrentTransactionsFromPostsView,wp2c_postmeta \n"
                    . "where order_id = $this->CurrentTransactionsFromPostsView.id AND \n"
                    . "meta_key = \"_billing_phone\" AND wp2c_postmeta.post_id = $this->CurrentTransactionsFromPostsView.id";
            $woocommerceStmt = $this->pdoConnectionWooCommerce->prepare($queryCurrentOrderItemsWithCustomerPhone);
            $woocommerceStmt->execute();
            $orderItemsWithCustomerPhone = $woocommerceStmt->fetchAll();
            /* -------------------------------------------------------------------------------------------------- */





            //5)Στοιχεία που θα βάλουμε στο transactions
            /* -------------------------------------------------------------------------------------------------- */
            $tableOrderItemMeta = tablePrefix . "woocommerce_order_itemmeta";
            $queryItemMeta = "
                        (SELECT meta_value FROM `wp2c_woocommerce_order_itemmeta` 
                         WHERE order_item_id in
                         (select order_item_id from $tablenameOrder,$this->CurrentTransactionsFromPostsView "
                    . "where order_id = $this->CurrentTransactionsFromPostsView.id) 
                          AND  meta_key='_line_total');";
            $woocommerceStmt = $this->pdoConnectionWooCommerce->prepare($queryItemMeta);
            $woocommerceStmt->execute();
            $currentOrderTotalLineTotal = $woocommerceStmt->fetchAll();
            /* -------------------------------------------------------------------------------------------------- */



            //6)Από τα στοιχεία που πήραμε στο 4,5 τα βάζουμε στον πίνακα allCurrentTransactions
            /* -------------------------------------------------------------------------------------------------- */
            $this->allCurrentTransactions = array(); //Σε αυτόν τον πίνακα περιέχονται οι συναλλαγές
            for ($i = 0; $i < sizeof($orderItemsWithCustomerPhone); $i++) {
                /* προσοχή το $customer_auto_id θα το πάρουμε αργότερα από τον customer */
                $this->allCurrentTransactions[$i] = new Transaction();
                $this->allCurrentTransactions[$i]->setCustomerAutoId($orderItemsWithCustomerPhone[$i][3]);
                $this->allCurrentTransactions[$i]->setEshopOrderId($orderItemsWithCustomerPhone[$i][1]);
                $this->allCurrentTransactions[$i]->setNotes($orderItemsWithCustomerPhone[$i][2]);
                $this->allCurrentTransactions[$i]->setMoney($currentOrderTotalLineTotal[$i][0]);
                $this->allCurrentTransactions[$i]->setPoints($currentOrderTotalLineTotal[$i][0]);
            }
            //Εκτύπωσει transaction
            /* foreach ($this->allCurrentTransactions as $transaction) {
              echo nl2br($transaction);
              } */
            /* -------------------------------------------------------------------------------------------------- */

            $this->addDataToOurDataBase();


            return;
            
            
        } catch (Exception $ex) {
            echo nl2br($ex->getMessage());
            return;
        }
    }

    function addDataToOurDataBase() {
        //Εκτέλεσει του ερωτήματος που φτίαχνει έναν customer αντικείμενο

        $tablePostMeta = tablePrefix . 'postmeta';

        //παίρνουμε τα email των πελατών και τα βάζουμε σε έναν πίνακα
        $queryGetEmails = "SELECT meta_value as email FROM $tablePostMeta,$this->CurrentTransactionsFromPostsView "
                . " WHERE   meta_key='_billing_email '&& "
                . "$tablePostMeta.post_id =$this->CurrentTransactionsFromPostsView.id ;";

        $woocommerceStmt = $this->pdoConnectionWooCommerce->prepare($queryGetEmails);
        $woocommerceStmt->execute();

        $emails = $woocommerceStmt->fetchAll();


        //παίρνουμε τα τηλέφωνα των πελατών και τα βάζουμε σε έναν πίνακα
        $queryGetPhones = "SELECT meta_value as phone FROM $tablePostMeta,$this->CurrentTransactionsFromPostsView "
                . " WHERE   meta_key='_billing_phone'&& "
                . "$tablePostMeta.post_id =$this->CurrentTransactionsFromPostsView.id ;";

        $woocommerceStmt = $this->pdoConnectionWooCommerce->prepare($queryGetPhones);
        $woocommerceStmt->execute();


        $phones = $woocommerceStmt->fetchAll();





        //παίρνουμε τα surname των πελατών και τα βάζουμε σε έναν πίνακα
        $queryGetSurname = "SELECT meta_value as name FROM $tablePostMeta,$this->CurrentTransactionsFromPostsView "
                . " WHERE   meta_key='_shipping_last_name'&& "
                . "$tablePostMeta.post_id =$this->CurrentTransactionsFromPostsView.id ;";

        $woocommerceStmt = $this->pdoConnectionWooCommerce->prepare($queryGetSurname);
        $woocommerceStmt->execute();

        $surnames = $woocommerceStmt->fetchAll();


        //παίρνουμε τα name των πελατών και τα βάζουμε σε έναν πίνακα
        $queryGetNames = "SELECT meta_value as name FROM $tablePostMeta,$this->CurrentTransactionsFromPostsView "
                . " WHERE   meta_key='_shipping_first_name'&& "
                . "$tablePostMeta.post_id =$this->CurrentTransactionsFromPostsView.id ;";

        $woocommerceStmt = $this->pdoConnectionWooCommerce->prepare($queryGetNames);
        $woocommerceStmt->execute();

        $names = $woocommerceStmt->fetchAll();


        //παίρνουμε το $street των πελατών και τα βάζουμε σε έναν πίνακα
        $queryGetStreets = "SELECT meta_value as name FROM $tablePostMeta,$this->CurrentTransactionsFromPostsView "
                . " WHERE   meta_key='_shipping_address_1'&& "
                . "$tablePostMeta.post_id =$this->CurrentTransactionsFromPostsView.id ;";

        $woocommerceStmt = $this->pdoConnectionWooCommerce->prepare($queryGetStreets);
        $woocommerceStmt->execute();

        $streets = $woocommerceStmt->fetchAll();

        //παίρνουμε το city των πελατών και τα βάζουμε σε έναν πίνακα
        $queryGetCities = "SELECT meta_value as city FROM $tablePostMeta,$this->CurrentTransactionsFromPostsView "
                . " WHERE   meta_key='_shipping_city'&& "
                . "$tablePostMeta.post_id =$this->CurrentTransactionsFromPostsView.id ;";

        $woocommerceStmt = $this->pdoConnectionWooCommerce->prepare($queryGetCities);
        $woocommerceStmt->execute();

        $cities = $woocommerceStmt->fetchAll();



        //παίρνουμε το country των πελατών και τα βάζουμε σε έναν πίνακα
        $queryGetCountries = "SELECT meta_value as country FROM $tablePostMeta,$this->CurrentTransactionsFromPostsView "
                . " WHERE   meta_key='_shipping_country'&& "
                . "$tablePostMeta.post_id =$this->CurrentTransactionsFromPostsView.id ;";

        $woocommerceStmt = $this->pdoConnectionWooCommerce->prepare($queryGetCountries);
        $woocommerceStmt->execute();

        $countries = $woocommerceStmt->fetchAll();






        $customers = array();
        for ($i = 0; $i < count($phones); $i++) {
            $customers[$i] = new Customer();
            $customers[$i]->setCountry($countries[$i][0]);
            $customers[$i]->setEmail($emails[$i][0]);
            $customers[$i]->setPhone($phones[$i][0]);
            $customers[$i]->setSurname($surnames[$i][0]);
            $customers[$i]->setName($names[$i][0]);
            $customers[$i]->setStreet($streets[$i][0]);
            $customers[$i]->setCity($cities[$i][0]);
            $customers[$i]->setOrder_id($this->currentWpPost[$i][0]);
        }
        //εκτώπωσει πελατών
        /* foreach ($customers as $customer) {
          echo nl2br($customer);
          echo "<br>";
          } */

        /* Το παρακάτω κομμάτι κώδικα στην ουσία αποθηκεύει 
         * στην db τους customers εάν δεν υπάρχουν και τις συνναλαγές
         */
        //Εδώ  κάνουμε δουλεία με την loyalty db
        for ($i = 0; $i < sizeof($customers); $i++) {
            $customer = $customers[$i]; //πάρε έναν έναν customer για να τον αποθηκεύσεις db
            $transaction = $this->allCurrentTransactions[$i]; //πάρε μια μια της συναλλαγές για να τις αποθηκεύσεις στην db


            $customerPhone = $customer->getPhone();
            $queryIfCustomerExistInLoyalty = "SELECT customer_id FROM customers "
                    . "where phone = '$customerPhone';";

            $stmt = $this->pdoConnectionLoyalty->query($queryIfCustomerExistInLoyalty);
            $result = $stmt->fetch();

            if (!$result)//εάν το ερώτημα δεν φέρει δεδομένα τότε είναι null
                $isCustomerExist = false; //Δεν υπάρχει ο χρήστης
            else {
                $customer_auto_id = $result[0];
                $isCustomerExist = true;
            }//Υπάρχει ο χρήστης

            $stmt = null;



            /* Βάλε τους χρήστες μέσα στην db */
            /* Σε αυτό το σημείο ενδέχεται να γίνει το update επειδή
             * μέχρι στιγμής δεν υπάρχει πουθενά το customer_id.
             * Το customer_id σε μελλοντικό update θα παίρνει τιμές
             * είτε από το woocommerce είτε θα το φτίαχνουμε 
             * εμείς και θα δείνουμε τιμή πάνω από 100.000 για να καταλαβαίνουμε
             * ότι είναι eshop
             * Τα παραπάνω μου τα είχε πεί ο Μάριος
             */
            try {
                $this->pdoConnectionLoyalty->beginTransaction();
                if ($isCustomerExist == false) {
                    $customerId = $customer->getCustomerId();
                    $customerName = $customer->getName();
                    $customerSurname = $customer->getSurname();
                    $customerStreet = $customer->getStreet();
                    $customerCity = $customer->getCity();
                    $customerCountry = $customer->getCountry();
                    $customerPhone = $customer->getPhone();
                    $customerEmail = $customer->getEmail();
                    $queryInsertCustomer = "INSERT INTO customers "
                            . "(customer_id,name,surname,street,city,country,phone,email)"
                            . " VALUES ('$customerId','$customerName','$customerSurname',"
                            . "'$customerStreet','$customerCity',"
                            . "'$customerCountry','$customerPhone',"
                            . "'$customerEmail');";
                    $stmt = $this->pdoConnectionLoyalty->query($queryInsertCustomer);
                    $stmt = null;
                }
                //βάλε τα transactions στην db
                $autoId = $customer_auto_id;

                $money = $transaction->getMoney();
                $points = $transaction->getPoints();
                $notes = $transaction->getNotes();
                $eshopOrderId = $transaction->getEshopOrderId();
                $query = "INSERT INTO transactions(customer_auto_id,money,points, notes,eshop_order_id)"
                        . " VALUES ($autoId,$money,$points,\"$notes\",$eshopOrderId);";


                $stmt = $this->pdoConnectionLoyalty->query($query);


                $this->pdoConnectionLoyalty->commit(); //όλα πήγαν καλά άρα τα αποθηκεύουμε
            } catch (Exception $ex) {

                echo nl2br($ex->getMessage());
            }
        }
    }

}

?>
