<?php

require_once "CreditsService.php";
require_once __DIR__ . "/../dao/CreditDao.php";

/**
 * Adds credits for a given accounts
 */
class SmsCreditsService implements CreditsService {
    
    /**
     * $creditDao CreditDao 
     */
    private $creditDao;
    
    /**
     * @param CreditDao $creditDao
     */
    public function __construct($creditDao) {
        $this->creditDao = $creditDao;
    }

    /**
     * @inheritDoc
     * @param Account $account
     * @param int $amount the amount of credits that was added
     */
    public function addCredits($account, $amount) {
        
        $credit = new Credit();
        $credit->setCredits($amount);
        $credit->setAccountid($account->getId());
        $credit->setCrdate(date('Y-m-d H:i:s', time()));
        $credit->setComments("Update through online payment");
        $this->creditDao->save($credit);
        return $amount;
    }

}
