<?php

namespace VivaWalletSDK;

require_once __DIR__ .'/Authentication.php';
require_once __DIR__ .'/Charge.php';
require_once __DIR__ .'/Transaction.php';

/**
 * Description of Utils
 *
 * @author George Kyriakopoulos
 */
class Utils {

    private function __construct() {
        
    }

    /**
     * 
     * @param type $json
     * @return \VivaWalletSDK\Authentication
     */
    static function authenticationFromJson($json) {

        $obj = json_decode($json);
        return new \VivaWalletSDK\Authentication($obj->access_token, $obj->expires_in, $obj->token_type);
    }

    /**
     * 
     * @param type $json
     * @return \VivaWalletSDK\Charge
     */
    static function chargeFromJson($json) {

        $obj = json_decode($json);
        return new \VivaWalletSDK\Charge($obj->chargeToken, $obj->redirectToACSForm);
    }

    /**
     * 
     * @param type $json
     * @return \VivaWalletSDK\Transaction
     */
    static function transactionFromJson($json) {

        $obj = json_decode($json);
        return new \VivaWalletSDK\Transaction($obj->transactionId);
    }

}
