<?php

namespace VivaWalletSDK;

/**
 * Description of Authentication
 *
 * @author George Kyriakopoulos
 */

class Authentication {
    
    /**
     * @var string 
     */
    private $accessToken;
    /**
     * @var DateTime 
     */
    private $createdAt;
    /**
     * @var int duration in seconds 
     */
    private $expiresIn;
    /**
     * @var string 
     */
    private $tokenType;
    
    function __construct($accessToken, $expiresIn, $tokenType) {
        $this->accessToken = $accessToken;
        $this->createdAt = new \DateTime();
        $this->expiresIn = $expiresIn;
        $this->tokenType = $tokenType;
    }
    
    function getAccessToken() {
        return $this->accessToken;
    }

    function getCreatedAt() {
        return $this->createdAt;
    }

    function getExpiresIn() {
        return $this->expiresIn;
    }

    function getTokenType() {
        return $this->tokenType;
    }

    function setAccessToken($accessToken) {
        $this->accessToken = $accessToken;
    }

    function setCreatedAt($createdAt) {
        $this->createdAt = $createdAt;
    }

    function setExpiresIn($expiresIn) {
        $this->expiresIn = $expiresIn;
    }

    function setTokenType($tokenType) {
        $this->tokenType = $tokenType;
    }

}
