<?php

namespace VivaWalletSDK;

require_once __DIR__.'/viva-config.php';
require_once __DIR__ .'/Utils.php';
require_once __DIR__ .'/Authentication.php';
require_once __DIR__ .'/CardDetails.php';
require_once __DIR__ .'/Transaction.php';
require_once __DIR__ .'/Charge.php';
require_once __DIR__ .'/../../../account-manager81/models/Account.php';

/**
 * Description of VivaWalletClient
 *
 * @author George Kyriakopoulos
 */
class VivaWalletClient {

    function __construct() {}

    /**
     * Get the access token from the identity provider
     * to use in subsequent calls to viva
     * @return \VivaWalletSDK\Authentication
     */
    function retrieveAccessToken() {

        $basicAuthToken = base64_encode(VIVA_WALLET_CLIENT_ID.":".VIVA_WALLET_CLIENT_SECRET);

        $headerArgs = array(
            "Authorization: Basic " . $basicAuthToken,
            "Accept: application/json",
            "Content-Type: application/x-www-form-urlencoded"
        );

        $curl = curl_init();
        curl_setopt($curl, CURLOPT_URL, VIVA_WALLET_AUTHORIZATION_TOKEN_URL);
        curl_setopt($curl, CURLOPT_RETURNTRANSFER, TRUE);
        curl_setopt($curl, CURLOPT_ENCODING, "");
        curl_setopt($curl, CURLOPT_MAXREDIRS, 10);
        curl_setopt($curl, CURLOPT_TIMEOUT, 0);
        curl_setopt($curl, CURLOPT_FOLLOWLOCATION, TRUE);
        curl_setopt($curl, CURLOPT_HTTP_VERSION, CURL_HTTP_VERSION_1_1);
        curl_setopt($curl, CURLOPT_CUSTOMREQUEST, "POST");
        curl_setopt($curl, CURLOPT_POSTFIELDS, "grant_type=client_credentials");
        curl_setopt($curl, CURLOPT_HTTPHEADER, $headerArgs);
        
        $result = curl_exec($curl);
        $httpcode = curl_getinfo($curl, CURLINFO_HTTP_CODE);
        curl_close($curl);
        
        if ($httpcode != 200) {
            return null;
        }

        $authentication = \VivaWalletSDK\Utils::authenticationFromJson($result);

        return $authentication;
    }

    /**
     * 
     * @param \VivaWalletSDK\Authentication $authentication
     * @param \VivaWalletSDK\CardDetails $cardDetails
     * @param int $amount
     * @param string $sessionRedirectUrl
     * @return \VivaWalletSDK\Charge
     */
    function chargeToken($authentication, $cardDetails, $amount, $sessionRedirectUrl) {

        $headerArgs = array(
            "Authorization: Bearer " . $authentication->getAccessToken(),
            "Content-Type: application/json"
        );

        $postArgs = array(
            'amount' => $amount,
            'cvc' => $cardDetails->getCvc(),
            'number' => $cardDetails->getNumber(),
            'holderName' => $cardDetails->getHolderName(),
            'expirationYear' => $cardDetails->getExpirationYear(),
            'expirationMonth' => $cardDetails->getExpirationMonth(),
            'sessionRedirectUrl' => $sessionRedirectUrl,
        );
        
        $curl = curl_init();
        curl_setopt($curl, CURLOPT_URL, VIVA_WALLET_CHARGE_TOKENS_URL);
        curl_setopt($curl, CURLOPT_RETURNTRANSFER, TRUE);
        curl_setopt($curl, CURLOPT_ENCODING, "");
        curl_setopt($curl, CURLOPT_MAXREDIRS, 10);
        curl_setopt($curl, CURLOPT_TIMEOUT, 0);
        curl_setopt($curl, CURLOPT_FOLLOWLOCATION, TRUE);
        curl_setopt($curl, CURLOPT_HTTP_VERSION, CURL_HTTP_VERSION_1_1);
        curl_setopt($curl, CURLOPT_CUSTOMREQUEST, "POST");
        curl_setopt($curl, CURLOPT_POSTFIELDS, json_encode($postArgs));
        curl_setopt($curl, CURLOPT_HTTPHEADER, $headerArgs);

        $result = curl_exec($curl);
        $httpcode = curl_getinfo($curl, CURLINFO_HTTP_CODE);
        curl_close($curl);

        if ($httpcode != 200) {
            return null;
        }

        return \VivaWalletSDK\Utils::chargeFromJson($result);
    }

    /**
     * 
     * @param \VivaWalletSDK\Authentication $authentication
     * @param \VivaWalletSDK\Charge $charge
     * @param Account $account
     * @param int $amount
     * @param string $receiptMessage The message describing the bought product
     * @return \VivaWalletSDK\Transaction
     */
    function makeTheActualCharge($authentication, $charge, $account,
            $amount, $receiptMessage = "Net2020 loyalty services") {

        $headerArgs = array(
            "Authorization: Bearer " . $authentication->getAccessToken(),
            "Content-Type: application/json",
            "Content-Type: text/plain"
        );

        $postArgs = array(
            'amount' => $amount,
            'chargeToken' => $charge->getChargeToken(),
            'installments' => 1,
            'preauth' => false,
            'merchantTrns' => $receiptMessage,
            'customerTrns' => $receiptMessage,
            'currencyCode' => 978, //EURO
            'customer' => array(
                'email' => $account->getEmail(),
                'phone' => $account->getPhone(),
                'fullname' => $account->getName(),
                'requestLang' => 'el',
                'countryCode' => 'GR'
            )
        );
        
        $curl = curl_init();
        curl_setopt($curl, CURLOPT_URL, VIVA_WALLET_TRANSACTIONS_URL);
        curl_setopt($curl, CURLOPT_RETURNTRANSFER, TRUE);
        curl_setopt($curl, CURLOPT_ENCODING, "");
        curl_setopt($curl, CURLOPT_MAXREDIRS, 10);
        curl_setopt($curl, CURLOPT_TIMEOUT, 0);
        curl_setopt($curl, CURLOPT_FOLLOWLOCATION, TRUE);
        curl_setopt($curl, CURLOPT_HTTP_VERSION, CURL_HTTP_VERSION_1_1);
        curl_setopt($curl, CURLOPT_CUSTOMREQUEST, "POST");
        curl_setopt($curl, CURLOPT_POSTFIELDS, json_encode($postArgs));
        curl_setopt($curl, CURLOPT_HTTPHEADER, $headerArgs);

        $result = curl_exec($curl);
        $httpcode = curl_getinfo($curl, CURLINFO_HTTP_CODE);
        curl_close($curl);
  
        if ($httpcode != 200) {
            return null;
        }
        
        return \VivaWalletSDK\Utils::transactionFromJson($result);
    }

}
